/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.saving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeListener;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeEvent;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeListenerRegistry;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeNotification;
import org.eclipse.sphinx.emf.workspace.saving.IModelSaveLifecycleListener;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSaveManager {
    public static ModelSaveManager INSTANCE = new ModelSaveManager();
    private Collection<IModelSaveLifecycleListener> modelDirtyChangeListeners = new ArrayList<IModelSaveLifecycleListener>();
    private Collection<IModelSaveLifecycleListener> modelPreSaveListeners = new ArrayList<IModelSaveLifecycleListener>();
    private IURIChangeListener uriChangeListener = new IURIChangeListener(){

        public void uriChanged(URIChangeEvent event) {
            if (event == null) {
                return;
            }
            HashSet<Resource> dirtyResources = new HashSet<Resource>();
            Resource changedResource = (Resource)event.getSource();
            if (changedResource == null) {
                return;
            }
            List<URIChangeNotification> notifications = event.getNotifications();
            for (URIChangeNotification notification : notifications) {
                EObject newEObject = notification.getNewEObject();
                Collection inverseReferences = EObjectUtil.getInverseReferences((EObject)newEObject, (boolean)true);
                for (EStructuralFeature.Setting inverseReference : inverseReferences) {
                    Resource referringResource = inverseReference.getEObject().eResource();
                    if (changedResource.equals(referringResource) || dirtyResources.contains(referringResource) || SaveIndicatorUtil.isDirty((EditingDomain)WorkspaceEditingDomainUtil.getEditingDomain((Object)referringResource), (Resource)referringResource)) continue;
                    SaveIndicatorUtil.setDirty((EditingDomain)WorkspaceEditingDomainUtil.getEditingDomain((Object)referringResource), (Resource)referringResource);
                    dirtyResources.add(referringResource);
                }
            }
        }
    };

    private ModelSaveManager() {
    }

    public void start() {
        URIChangeListenerRegistry.INSTANCE.addListener(this.uriChangeListener);
    }

    public void stop() {
        URIChangeListenerRegistry.INSTANCE.removeListener(this.uriChangeListener);
    }

    public void addModelDirtyChangedListener(IModelSaveLifecycleListener listener) {
        this.modelDirtyChangeListeners.add(listener);
    }

    public void removeModelDirtyChangedListener(IModelSaveLifecycleListener listener) {
        this.modelDirtyChangeListeners.remove(listener);
    }

    public void addModelPreSaveListener(IModelSaveLifecycleListener listener) {
        this.modelPreSaveListeners.add(listener);
    }

    public void removeModelPreSaveListener(IModelSaveLifecycleListener listener) {
        this.modelPreSaveListeners.remove(listener);
    }

    public void notifyDirtyChanged(Object source) {
        if (source == null) {
            return;
        }
        for (IModelSaveLifecycleListener listener : this.modelDirtyChangeListeners) {
            for (IModelDescriptor modelDescriptor : this.getModelDescriptors(source)) {
                listener.handleDirtyChangedEvent(modelDescriptor);
            }
        }
    }

    public void notifyPreSave(Object source) {
        if (source == null) {
            return;
        }
        for (IModelSaveLifecycleListener listener : this.modelPreSaveListeners) {
            for (IModelDescriptor modelDescriptor : this.getModelDescriptors(source)) {
                listener.handlePreSaveEvent(modelDescriptor);
            }
        }
    }

    protected Set<IModelDescriptor> getModelDescriptors(Object source) {
        HashSet<IModelDescriptor> modelDescriptors = new HashSet<IModelDescriptor>();
        if (source instanceof IModelDescriptor) {
            modelDescriptors.add((IModelDescriptor)source);
        } else if (source instanceof IContainer) {
            IContainer container = (IContainer)source;
            modelDescriptors.addAll(ModelDescriptorRegistry.INSTANCE.getModels(container));
        } else {
            Resource resource = EcorePlatformUtil.getResource((Object)source);
            if (resource != null) {
                IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(resource);
                if (modelDescriptor != null) {
                    modelDescriptors.add(modelDescriptor);
                }
            } else {
                String reason = NLS.bind((String)Messages.error_unexpectedSourceType, (Object)source.getClass().getSimpleName());
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(String.valueOf(PlatformMessages.error_caseNotYetSupported) + "\n" + reason));
            }
        }
        return modelDescriptors;
    }

    public boolean isDirty(Resource contextResource) {
        return this.isDirty(EcorePlatformUtil.getFile((Resource)contextResource));
    }

    public boolean isDirty(IFile contextFile) {
        IModelDescriptor model = ModelDescriptorRegistry.INSTANCE.getModel(contextFile);
        return this.isDirty(model);
    }

    public boolean isDirty(IContainer container) {
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels(container);
        for (IModelDescriptor modelDescriptor : models) {
            if (!this.isDirty(modelDescriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(IModelDescriptor modelDescriptor) {
        return SaveIndicatorUtil.isDirty((IModelDescriptor)modelDescriptor);
    }

    public void setDirty(Resource resource) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)resource);
        SaveIndicatorUtil.setDirty((EditingDomain)editingDomain, (Resource)resource);
    }

    public void setDirty(IFile file) {
        Resource resource;
        if (file != null && file.isAccessible() && (resource = EcorePlatformUtil.getResource((IFile)file)) != null) {
            this.setDirty(resource);
        }
    }

    public void setDirty(IContainer container) {
        if (container != null && container.isAccessible()) {
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IFile) {
                        this.setDirty((IFile)member);
                    } else if (member instanceof IContainer) {
                        this.setDirty((IContainer)member);
                    }
                    ++n2;
                }
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
            }
        }
    }

    public void setSaved(Resource resource) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)resource);
        SaveIndicatorUtil.setSaved((EditingDomain)editingDomain, (Resource)resource);
    }

    public void setSaved(IFile file) {
        Resource resource;
        if (file != null && file.isAccessible() && (resource = EcorePlatformUtil.getResource((IFile)file)) != null) {
            this.setSaved(resource);
        }
    }

    public void setSaved(IContainer container) {
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels(container);
        for (IModelDescriptor modelDescriptor : models) {
            this.setSaved(modelDescriptor);
        }
    }

    public void setSaved(IModelDescriptor modelDescriptor) {
        if (modelDescriptor != null) {
            SaveIndicatorUtil.setSaved((IModelDescriptor)modelDescriptor);
        }
    }

    public void saveModel(Resource contextResource, boolean async, IProgressMonitor monitor) {
        this.saveModel(contextResource, EcoreResourceUtil.getDefaultSaveOptions(), async, monitor);
    }

    public void saveModel(Resource contextResource, Map<?, ?> saveOptions, boolean async, IProgressMonitor monitor) {
        this.notifyPreSave(contextResource);
        EcorePlatformUtil.saveModel((Object)contextResource, saveOptions, (boolean)async, (IProgressMonitor)monitor);
        this.notifyDirtyChanged(contextResource);
    }

    public void saveModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.saveModel(modelDescriptor, EcoreResourceUtil.getDefaultSaveOptions(), async, monitor);
    }

    public void saveModel(IModelDescriptor modelDescriptor, Map<?, ?> saveOptions, boolean async, IProgressMonitor monitor) {
        this.notifyPreSave(modelDescriptor);
        EcorePlatformUtil.saveModel((Object)modelDescriptor, saveOptions, (boolean)async, (IProgressMonitor)monitor);
        this.notifyDirtyChanged(modelDescriptor);
    }

    public void saveProject(IProject project, boolean async, IProgressMonitor monitor) {
        this.saveProject(project, EcoreResourceUtil.getDefaultSaveOptions(), async, monitor);
    }

    public void saveProject(IProject project, Map<?, ?> saveOptions, boolean async, IProgressMonitor monitor) {
        this.notifyPreSave(project);
        EcorePlatformUtil.saveProject((IProject)project, saveOptions, (boolean)async, (IProgressMonitor)monitor);
        this.notifyDirtyChanged(project);
    }
}

