/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ListBinding
extends Binding {
    private UpdateListStrategy targetToModel;
    private UpdateListStrategy modelToTarget;
    private IObservableValue validationStatusObservable;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IListChangeListener targetChangeListener = event -> {
        if (!this.updatingTarget) {
            this.doUpdate((IObservableList)this.getTarget(), (IObservableList)this.getModel(), event.diff, this.targetToModel, false, false);
        }
    };
    private IListChangeListener modelChangeListener = event -> {
        if (!this.updatingModel) {
            this.doUpdate((IObservableList)this.getModel(), (IObservableList)this.getTarget(), event.diff, this.modelToTarget, false, false);
        }
    };

    public ListBinding(IObservableList target, IObservableList model, UpdateListStrategy targetToModelStrategy, UpdateListStrategy modelToTargetStrategy) {
        super((IObservable)target, (IObservable)model);
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
    }

    @Override
    public IObservableValue getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            this.getModel().getRealm().exec(() -> {
                ((IObservableList)this.getModel()).addListChangeListener(this.modelChangeListener);
                this.updateModelToTarget();
            });
        } else {
            this.modelChangeListener = null;
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            this.getTarget().getRealm().exec(() -> {
                ((IObservableList)this.getTarget()).addListChangeListener(this.targetChangeListener);
                if (this.modelToTarget.getUpdatePolicy() == UpdateListStrategy.POLICY_NEVER) {
                    this.updateTargetToModel();
                } else {
                    this.validateTargetToModel();
                }
            });
        } else {
            this.targetChangeListener = null;
        }
    }

    @Override
    public void updateModelToTarget() {
        IObservableList modelList = (IObservableList)this.getModel();
        modelList.getRealm().exec(() -> {
            ListDiff diff = Diffs.computeListDiff((List)Collections.EMPTY_LIST, (List)modelList);
            this.doUpdate(modelList, (IObservableList)this.getTarget(), diff, this.modelToTarget, true, true);
        });
    }

    @Override
    public void updateTargetToModel() {
        IObservableList targetList = (IObservableList)this.getTarget();
        targetList.getRealm().exec(() -> {
            ListDiff diff = Diffs.computeListDiff((List)Collections.EMPTY_LIST, (List)targetList);
            this.doUpdate(targetList, (IObservableList)this.getModel(), diff, this.targetToModel, true, true);
        });
    }

    @Override
    public void validateModelToTarget() {
    }

    @Override
    public void validateTargetToModel() {
    }

    private void doUpdate(IObservableList source, final IObservableList destination, ListDiff diff, final UpdateListStrategy updateListStrategy, boolean explicit, boolean clearDestination) {
        int policy = updateListStrategy.getUpdatePolicy();
        if (policy != UpdateListStrategy.POLICY_NEVER && (policy != UpdateListStrategy.POLICY_ON_REQUEST || explicit)) {
            if (!destination.getRealm().isCurrent()) {
                diff.getDifferences();
            }
            destination.getRealm().exec(() -> {
                if (destination == this.getTarget()) {
                    this.updatingTarget = true;
                } else {
                    this.updatingModel = true;
                }
                final BindingStatus multiStatus = BindingStatus.ok();
                try {
                    if (clearDestination) {
                        destination.clear();
                    }
                    diff.accept(new ListDiffVisitor(){
                        boolean useMoveAndReplace;
                        {
                            this.useMoveAndReplace = updateListStrategy2.useMoveAndReplace();
                        }

                        public void handleAdd(int index, Object element) {
                            IStatus setterStatus = updateListStrategy.doAdd(destination, updateListStrategy.convert(element), index);
                            ListBinding.this.mergeStatus(multiStatus, setterStatus);
                        }

                        public void handleRemove(int index, Object element) {
                            IStatus setterStatus = updateListStrategy.doRemove(destination, index);
                            ListBinding.this.mergeStatus(multiStatus, setterStatus);
                        }

                        public void handleMove(int oldIndex, int newIndex, Object element) {
                            if (this.useMoveAndReplace) {
                                IStatus setterStatus = updateListStrategy.doMove(destination, oldIndex, newIndex);
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            } else {
                                super.handleMove(oldIndex, newIndex, element);
                            }
                        }

                        public void handleReplace(int index, Object oldElement, Object newElement) {
                            if (this.useMoveAndReplace) {
                                IStatus setterStatus = updateListStrategy.doReplace(destination, index, newElement);
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            } else {
                                super.handleReplace(index, oldElement, newElement);
                            }
                        }
                    });
                }
                finally {
                    this.setValidationStatus((IStatus)multiStatus);
                    if (destination == this.getTarget()) {
                        this.updatingTarget = false;
                    } else {
                        this.updatingModel = false;
                    }
                }
            });
        }
    }

    private void setValidationStatus(IStatus status) {
        this.validationStatusObservable.getRealm().exec(() -> this.validationStatusObservable.setValue((Object)status));
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            ((IObservableList)this.getTarget()).removeListChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            ((IObservableList)this.getModel()).removeListChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

