/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.controls;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.MetamodelPackage;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.ui.editor.ModelDiagramEditor;
import org.eclipse.stem.model.ui.editor.VisualModelReconciler;
import org.eclipse.stem.model.ui.editor.actions.RunModelGeneratorAction;
import org.eclipse.stem.model.ui.editor.commands.ModelCreateCommand;
import org.eclipse.stem.model.ui.editor.commands.emf.EmfCommandWrapper;
import org.eclipse.stem.model.ui.editor.controls.ModelParametersEditorDialog;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.editor.vismodel.VisualMetamodelFactory;
import org.eclipse.stem.model.ui.editor.vismodel.provider.VisualMetamodelEditPlugin;
import org.eclipse.stem.model.ui.wizards.ModelCompartmentEditorDialog;
import org.eclipse.stem.model.ui.wizards.NewModelWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class VisualEditorToolbar
extends Composite {
    private ToolEntry selectTool;
    private ToolEntry drawTool;
    private ModelDiagramEditor editor;
    private ComboViewer modelViewer;
    private ToolItem runModelGeneratorButton;
    private ToolItem drawTransitionButton;
    private ToolItem selectButton;
    private ToolItem editModelButton;
    private ToolItem addModelButton;
    private ToolItem addCompartmentButton;
    private Image defaultImage;

    private void setupTools() {
        this.selectTool = new PanningSelectionToolEntry();
        this.drawTool = new ConnectionCreationToolEntry("Transition", "Create a solid-line connection", new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return new Object();
            }
        }, ImageDescriptor.createFromFile(ModelDiagramEditor.class, (String)"icons/connection_s16.gif"), ImageDescriptor.createFromFile(ModelDiagramEditor.class, (String)"icons/connection_s24.gif"));
        this.defaultImage = new Image((Device)this.getDisplay(), 20, 20);
        Color color = this.getDisplay().getSystemColor(9);
        GC gc = new GC((Drawable)this.defaultImage);
        gc.setBackground(color);
        gc.fillRectangle(this.defaultImage.getBounds());
        gc.dispose();
    }

    public VisualEditorToolbar(final ModelDiagramEditor editor, Composite parent, int style) {
        super(parent, style);
        this.editor = editor;
        this.setupTools();
        VisualMetamodelEditPlugin resourceLocator = VisualMetamodelEditPlugin.INSTANCE;
        this.setLayout((Layout)new GridLayout(3, false));
        Label topBarLabel = new Label((Composite)this, 0);
        topBarLabel.setText("Model");
        this.modelViewer = new ComboViewer((Composite)this, 8);
        this.modelViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelElement) {
                    return ((ModelElement)element).getModel().getName();
                }
                return "";
            }
        });
        this.modelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editor.setDiagramElement(VisualEditorToolbar.this.getSelectedModel());
            }
        });
        ToolBar toolbar = new ToolBar((Composite)this, 0);
        this.editModelButton = new ToolItem(toolbar, 8);
        this.editModelButton.setImage(ExtendedImageRegistry.INSTANCE.getImage(resourceLocator.getImage("EditModel.gif")));
        this.editModelButton.setToolTipText("Edit Model");
        this.editModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditorToolbar.this.launchEditModel();
            }
        });
        this.addModelButton = new ToolItem(toolbar, 8);
        this.addModelButton.setImage(ExtendedImageRegistry.INSTANCE.getImage(resourceLocator.getImage("AddModelIcon16")));
        this.addModelButton.setToolTipText("Add Model");
        this.addModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditorToolbar.this.launchAddModel();
            }
        });
        this.addCompartmentButton = new ToolItem(toolbar, 8);
        this.addCompartmentButton.setImage(ExtendedImageRegistry.INSTANCE.getImage(resourceLocator.getImage("AddCompartmentIcon24")));
        this.addCompartmentButton.setToolTipText("Add Compartment");
        this.addCompartmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditorToolbar.this.launchAddCompartment();
            }
        });
        new ToolItem(toolbar, 514);
        this.selectButton = new ToolItem(toolbar, 32);
        this.selectButton.setImage(ExtendedImageRegistry.INSTANCE.getImage(resourceLocator.getImage("SelectIcon20")));
        this.selectButton.setToolTipText("Select Compartment");
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VisualEditorToolbar.this.selectButton.getSelection()) {
                    VisualEditorToolbar.this.selectButton.setSelection(true);
                }
                editor.getEditingDomain().setActiveTool(VisualEditorToolbar.this.selectTool.createTool());
                VisualEditorToolbar.this.drawTransitionButton.setSelection(false);
            }
        });
        this.drawTransitionButton = new ToolItem(toolbar, 32);
        this.drawTransitionButton.setImage(ExtendedImageRegistry.INSTANCE.getImage(resourceLocator.getImage("DrawTransitionIcon20")));
        this.drawTransitionButton.setToolTipText("Draw New Transition");
        this.drawTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VisualEditorToolbar.this.drawTransitionButton.getSelection()) {
                    VisualEditorToolbar.this.drawTransitionButton.setSelection(true);
                }
                editor.getEditingDomain().setActiveTool(VisualEditorToolbar.this.drawTool.createTool());
                VisualEditorToolbar.this.selectButton.setSelection(false);
            }
        });
        new ToolItem(toolbar, 2);
        this.runModelGeneratorButton = new ToolItem(toolbar, 8);
        this.runModelGeneratorButton.setImage(ExtendedImageRegistry.INSTANCE.getImage(resourceLocator.getImage("RunModelGeneratorIcon20")));
        this.runModelGeneratorButton.setToolTipText("Run Model Generator");
        this.runModelGeneratorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditorToolbar.this.launchModelGenerator();
            }
        });
        this.setInput();
        this.selectButton.setSelection(true);
    }

    protected void setInput() {
        EList<ModelElement> models = this.editor.getVisualModel().getModelElements();
        this.modelViewer.setInput(models);
        if (models.size() > 0 && models.get(0) != null) {
            this.modelViewer.setSelection((ISelection)new StructuredSelection(models.get(0)));
        }
    }

    public void inputChanged() {
        this.setInput();
    }

    private void launchModelGenerator() {
        RunModelGeneratorAction action = new RunModelGeneratorAction(this.editor);
        action.run();
    }

    private ModelElement getSelectedModel() {
        return (ModelElement)((IStructuredSelection)this.modelViewer.getSelection()).getFirstElement();
    }

    private void launchAddCompartment() {
        ModelElement selected = this.getSelectedModel();
        if (selected == null) {
            return;
        }
        Compartment newCompartment = MetamodelFactory.eINSTANCE.createCompartment();
        ModelCompartmentEditorDialog compartmentEditorDialog = new ModelCompartmentEditorDialog(this.getShell(), 0, selected.getModel().getCompartments(), newCompartment, null);
        if (compartmentEditorDialog.open() == 0) {
            selected.getModel().getCompartments().getCompartments().add((Object)newCompartment);
            CompartmentElement ce = VisualMetamodelFactory.eINSTANCE.createCompartmentElement();
            ce.setCompartment(newCompartment);
            ce.setX(10);
            ce.setY(10);
            ce.setWidth(50);
            ce.setHeight(50);
            selected.getCompartmentElements().add((Object)ce);
        }
    }

    private void launchEditModel() {
        ModelElement selected = this.getSelectedModel();
        if (selected == null || selected.getModel() == null) {
            return;
        }
        ModelParametersEditorDialog dialog = new ModelParametersEditorDialog(this.getShell(), selected.getModel());
        if (dialog.open() == 0) {
            this.editor.getCommandStack().execute((org.eclipse.gef.commands.Command)new EmfCommandWrapper((Command)UnexecutableCommand.INSTANCE));
        }
    }

    private void launchAddModel() {
        Model model = MetamodelFactory.eINSTANCE.createModel();
        NewModelWizard wizard = new NewModelWizard(model, this.editor.getMetamodel(), false, true);
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            EditingDomain editingDomain = this.editor.getMetamodelEditingDomain();
            CompoundCommand command = new CompoundCommand();
            command.add((org.eclipse.gef.commands.Command)new EmfCommandWrapper(AddCommand.create((EditingDomain)editingDomain, (Object)this.editor.getMetamodel(), (Object)MetamodelPackage.Literals.PACKAGE__MODELS, (Object)model)));
            command.add((org.eclipse.gef.commands.Command)new EmfCommandWrapper(AddCommand.create((EditingDomain)editingDomain, (Object)this.editor.getMetamodel(), (Object)MetamodelPackage.Literals.PACKAGE__COMPARTMENT_GROUPS, (Object)model.getCompartments())));
            ModelElement me = VisualModelReconciler.initializeModelElement(model);
            command.add((org.eclipse.gef.commands.Command)new ModelCreateCommand(this.editor.getVisualModel(), me));
            this.editor.getCommandStack().execute((org.eclipse.gef.commands.Command)command);
            this.modelViewer.refresh();
            this.selectModel(me);
        }
    }

    public void selectModel(ModelElement me) {
        this.modelViewer.setSelection((ISelection)new StructuredSelection((Object)me));
    }
}

