/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.xml.sax.Attributes;

public class AntAntNode
extends AntTaskNode {
    private String fFile;

    public AntAntNode(Task task, Attributes attributes) {
        super(task);
        File basedir;
        StringBuffer label = new StringBuffer("ant ");
        this.fFile = attributes.getValue("dir");
        if (this.fFile != null) {
            if (!FileUtils.isAbsolutePath((String)this.fFile) && (basedir = task.getProject().getBaseDir()) != null) {
                this.fFile = String.valueOf(basedir.getAbsolutePath()) + File.separatorChar + this.fFile;
            }
            label.append(this.fFile);
            label.append(File.separatorChar);
        } else {
            basedir = task.getProject().getBaseDir();
            if (basedir != null) {
                this.fFile = basedir.getAbsolutePath();
            }
        }
        String fileName = attributes.getValue("antfile");
        if (fileName == null) {
            fileName = "build.xml";
        }
        label.append(fileName);
        this.fFile = this.fFile == null || FileUtils.isAbsolutePath((String)fileName) ? fileName : String.valueOf(this.fFile) + File.separatorChar + fileName;
        String more = attributes.getValue("target");
        if (more != null) {
            label.append(' ');
            label.append(more);
        }
        this.setBaseLabel(label.toString());
    }

    @Override
    public String getReferencedElement(int offset) {
        String attributeString;
        String textToSearch;
        if (this.fFile != null && (textToSearch = this.getAntModel().getText(this.getOffset(), offset - this.getOffset())) != null && textToSearch.length() != 0 && "antfile".equals(attributeString = AntEditorCompletionProcessor.getAttributeStringFromDocumentStringToPrefix(textToSearch))) {
            return this.fFile;
        }
        return null;
    }
}

