/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class Document {
    private final Integer version;
    private final String contents;

    public int getOffSet(Position position) {
        int l = this.contents.length();
        int NL = 10;
        int line = 0;
        int column = 0;
        for (int i = 0; i < l; ++i) {
            char ch = this.contents.charAt(i);
            if (position.getLine() == line && position.getCharacter() == column) {
                return i;
            }
            if (ch == '\n') {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        if (position.getLine() == line && position.getCharacter() == column) {
            return l;
        }
        String _string = position.toString();
        String _plus = _string + " text was : ";
        String _plus_1 = _plus + this.contents;
        throw new IndexOutOfBoundsException(_plus_1);
    }

    public Position getPosition(int offset) {
        int l = this.contents.length();
        if (offset < 0 || offset > l) {
            String _plus = Integer.valueOf(offset) + " text was : ";
            String _plus_1 = _plus + this.contents;
            throw new IndexOutOfBoundsException(_plus_1);
        }
        int NL = 10;
        int line = 0;
        int column = 0;
        for (int i = 0; i < l; ++i) {
            char ch = this.contents.charAt(i);
            if (i == offset) {
                return new Position(line, column);
            }
            if (ch == '\n') {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        return new Position(line, column);
    }

    public String getSubstring(Range range) {
        int start = this.getOffSet(range.getStart());
        int end = this.getOffSet(range.getEnd());
        return this.contents.substring(start, end);
    }

    public Document applyChanges(Iterable<? extends TextEdit> changes) {
        String newContent = this.contents;
        for (TextEdit textEdit : changes) {
            String _plus_1;
            boolean _tripleEquals;
            Range _range = textEdit.getRange();
            boolean bl = _tripleEquals = _range == null;
            if (_tripleEquals) {
                newContent = textEdit.getNewText();
                continue;
            }
            int start = this.getOffSet(textEdit.getRange().getStart());
            int end = this.getOffSet(textEdit.getRange().getEnd());
            String _substring = newContent.substring(0, start);
            String _newText = textEdit.getNewText();
            String _plus = _substring + _newText;
            String _substring_1 = newContent.substring(end);
            newContent = _plus_1 = _plus + _substring_1;
        }
        Integer _xifexpression = null;
        _xifexpression = this.version != null ? Integer.valueOf(this.version + 1) : null;
        return new Document(_xifexpression, newContent);
    }

    public Document(Integer version, String contents) {
        this.version = version;
        this.contents = contents;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.contents == null ? other.contents != null : !this.contents.equals(other.contents));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("version", (Object)this.version);
        b.add("contents", (Object)this.contents);
        return b.toString();
    }

    @Pure
    public Integer getVersion() {
        return this.version;
    }

    @Pure
    public String getContents() {
        return this.contents;
    }
}

