/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.vector.impl;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.vector.VectorDiseaseModel;
import org.eclipse.stem.diseasemodels.vector.VectorPackage;
import org.eclipse.stem.diseasemodels.vector.impl.Messages;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;
import org.eclipse.stem.populationmodels.standard.impl.StandardFactoryImpl;

public abstract class VectorDiseaseModelImpl
extends StandardDiseaseModelImpl
implements VectorDiseaseModel {
    protected static final String VECTOR_POPULATION_IDENTIFIER_EDEFAULT = "anopheles";
    protected String vectorPopulationIdentifier = "anopheles";

    protected VectorDiseaseModelImpl() {
    }

    protected EClass eStaticClass() {
        return VectorPackage.Literals.VECTOR_DISEASE_MODEL;
    }

    @Override
    public String getVectorPopulationIdentifier() {
        return this.vectorPopulationIdentifier;
    }

    @Override
    public void setVectorPopulationIdentifier(String newVectorPopulationIdentifier) {
        this.vectorPopulationIdentifier = newVectorPopulationIdentifier;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getVectorPopulationIdentifier();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setVectorPopulationIdentifier((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setVectorPopulationIdentifier(VECTOR_POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return VECTOR_POPULATION_IDENTIFIER_EDEFAULT == null ? this.vectorPopulationIdentifier != null : !VECTOR_POPULATION_IDENTIFIER_EDEFAULT.equals(this.vectorPopulationIdentifier);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (vectorPopulationIdentifier: ");
        result.append(this.vectorPopulationIdentifier);
        result.append(')');
        return result.toString();
    }

    public void prepare(Model model, STEMTime time) {
        super.prepare(model, time);
        boolean found = this.findPopulationModel(model, this.getVectorPopulationIdentifier());
        if (!found) {
            StandardPopulationModel spm = StandardFactoryImpl.eINSTANCE.createStandardPopulationModel();
            spm.setPopulationIdentifier(this.getVectorPopulationIdentifier());
            String title = "Auto Generated " + this.getVectorPopulationIdentifier() + " population model";
            String name = "auto_gen_" + this.getVectorPopulationIdentifier() + "_population_model";
            spm.setURI(STEMURI.createURI((String)(String.valueOf(name) + "/" + STEMURI.generateUniquePart())));
            spm.setName(name);
            spm.getDublinCore().setTitle(title);
            model.getNodeDecorators().add(0, (Object)spm);
        }
    }

    public EList<PopulationModelLabel> getPopulationModelLabels(String populationIdentifier, Graph graph) throws ScenarioInitializationException {
        BasicEList retValue = new BasicEList();
        EList labels = graph.getNodeLabelsByTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        boolean foundHuman = false;
        boolean foundVector = false;
        for (NodeLabel pl : labels) {
            PopulationModelLabel populationLabel = (PopulationModelLabel)pl;
            boolean keep = false;
            if (populationLabel.getPopulationIdentifier().equals(populationIdentifier)) {
                keep = true;
                foundHuman = true;
            } else if (populationLabel.getPopulationIdentifier().equals(this.getVectorPopulationIdentifier())) {
                keep = true;
                foundVector = true;
            }
            if (!keep || populationLabel.getNode() == null) continue;
            retValue.add((Object)populationLabel);
        }
        if (!foundHuman) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.HOST_POP_MOD_LABEL_NOT_FOUND, (Object[])new Object[]{this.getURI().toString(), this.getPopulationIdentifier()}), (Identifiable)this, new Exception());
        }
        if (!foundVector) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.VECTOR_POP_MOD_LABEL_NOT_FOUND, (Object[])new Object[]{this.getURI().toString(), this.getVectorPopulationIdentifier()}), (Identifiable)this, new Exception());
        }
        return retValue;
    }

    public EList<String> getAllLabelIdentifiers() {
        BasicEList identifiers = new BasicEList();
        identifiers.add((Object)this.getPopulationIdentifier());
        identifiers.add((Object)this.getVectorPopulationIdentifier());
        return identifiers;
    }
}

