/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.text.NumberFormat;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;

public class InlineLatLongDataProvider
implements LatLongDataProvider {
    public static final String INLINE_SCHEME = "inline";
    private static final int NUMBER_OF_FACTIONAL_DIGITS = 2;
    private static NumberFormat formatter = null;

    @Override
    public LatLong getLatLong(URI dataURI) {
        LatLong retValue = new LatLong();
        String[] segments = dataURI.segments();
        try {
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segmentString = stringArray[n2];
                LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
                StringTokenizer st = new StringTokenizer(segmentString, ",");
                while (st.hasMoreTokens()) {
                    String latitudeString = st.nextToken();
                    if (st.hasMoreTokens()) {
                        sb.add(latitudeString, st.nextToken());
                        continue;
                    }
                    Activator.logError("Inline lat/long data \"" + segmentString + "\" is missing a longitude match for the latitude \"" + latitudeString + "\"", null);
                    sb.clear();
                    break;
                }
                if (sb.size() > 0) {
                    retValue.add(sb.toSegment());
                }
                ++n2;
            }
        }
        catch (NumberFormatException nfe) {
            Activator.logInformation("Inline lat/long data is not properly formatted" + nfe.getMessage());
        }
        return retValue;
    }

    @Override
    public LatLong getLatLongNoWait(URI dataURI) {
        return this.getLatLong(dataURI);
    }

    public static String createSpatialInlineURIString(LatLong segmentArrays) {
        StringBuilder sb = new StringBuilder("stemspatial:");
        sb.append(InlineLatLongDataProvider.createInlineURIString(segmentArrays));
        return sb.toString();
    }

    public static String createInlineURIString(LatLong latLong) {
        StringBuilder sb = new StringBuilder(INLINE_SCHEME);
        sb.append("://");
        for (LatLong.Segment segment : latLong.getSegments()) {
            sb.append("/");
            sb.append(segment.toInlineURIString());
        }
        return sb.toString();
    }

    private static NumberFormat getFormatter() {
        if (formatter == null) {
            formatter = NumberFormat.getNumberInstance();
            formatter.setMaximumFractionDigits(2);
            formatter.setMinimumFractionDigits(2);
        }
        return formatter;
    }
}

