/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.RelativeValueColorProvider;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractRelativeValueColorProviderAdapter
extends ColorProviderAdapter
implements RelativeValueColorProvider {
    private STEMColor max_FillColor;
    private STEMColor range_09_1_FillColor;
    private STEMColor range_08_09_FillColor;
    private STEMColor range_07_08_FillColor;
    private STEMColor range_06_07_FillColor;
    private STEMColor range_05_06_FillColor;
    private STEMColor range_04_05_FillColor;
    private STEMColor range_03_04_FillColor;
    private STEMColor range_02_03_FillColor;
    private STEMColor range_01_02_FillColor;
    private STEMColor range_0_01_FillColor;
    protected STEMColor zero_FillColor;
    protected STEMColor foregroundFillColor;
    protected STEMColor borderColor;
    protected int alpha = 255;
    public STEMColor backgroundFillColor;
    protected final float ZERO_RELATIVE_VALUE_THRESHOLD = 1.0E-9f;
    protected Decorator selectedDecorator = null;
    protected String selectedPopulationIdentifier = null;
    protected RelativeValueProviderAdapter rvp = null;
    protected Device device = null;

    public AbstractRelativeValueColorProviderAdapter() {
        this.updateColorsFromPreferences();
    }

    @Override
    public STEMColor getColor() {
        return this.getColor(1.0f, false);
    }

    @Override
    public STEMColor getColor(float gainFactor, boolean useLogScaling) {
        double relativeValue = this.performGainAndLogScaling(this.getRelativeValue(), gainFactor, useLogScaling);
        return this.getColorForRelativeValue(relativeValue);
    }

    @Override
    public abstract float getRelativeValue();

    @Override
    public STEMColor getColorForRelativeValue(double relativeValue) {
        STEMColor retValue = new STEMColor();
        this.updateColorsFromPreferences();
        if (relativeValue == 1.0) {
            retValue = this.max_FillColor;
        } else if (relativeValue > 0.9) {
            retValue = this.range_09_1_FillColor;
        } else if (relativeValue > 0.8) {
            retValue = this.range_08_09_FillColor;
        } else if (relativeValue > 0.7) {
            retValue = this.range_07_08_FillColor;
        } else if (relativeValue > 0.6) {
            retValue = this.range_06_07_FillColor;
        } else if (relativeValue > 0.5) {
            retValue = this.range_05_06_FillColor;
        } else if (relativeValue > 0.4) {
            retValue = this.range_04_05_FillColor;
        } else if (relativeValue > 0.3) {
            retValue = this.range_03_04_FillColor;
        } else if (relativeValue > 0.2) {
            retValue = this.range_02_03_FillColor;
        } else if (relativeValue > 0.1) {
            retValue = this.range_01_02_FillColor;
        } else if (relativeValue > (double)1.0E-9f) {
            retValue = this.range_0_01_FillColor;
        } else if (relativeValue <= (double)1.0E-9f) {
            retValue = this.zero_FillColor;
        }
        return retValue;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == RelativeValueColorProvider.class;
    }

    private STEMColor getColorFromString(String rgbString) {
        if (rgbString == null || "".equals(rgbString)) {
            return new STEMColor();
        }
        RGB rgb = StringConverter.asRGB((String)rgbString);
        return new STEMColor(rgb.red, rgb.green, rgb.blue);
    }

    protected void updateColorsFromPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.max_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolormaximum"));
        this.range_09_1_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange10"));
        this.range_08_09_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange9"));
        this.range_07_08_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange8"));
        this.range_06_07_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange7"));
        this.range_05_06_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange6"));
        this.range_04_05_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange5"));
        this.range_03_04_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange4"));
        this.range_02_03_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange3"));
        this.range_01_02_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange2"));
        this.range_0_01_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange1"));
        this.zero_FillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorzero"));
        this.foregroundFillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolor"));
        this.backgroundFillColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor"));
        this.borderColor = this.getColorFromString(preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.borderscolor"));
    }

    @Override
    public void setSelectedDecorator(Decorator selectedDecorator) {
        this.selectedDecorator = selectedDecorator;
    }

    @Override
    public void setSelectedPopulationIdentifier(String selectedId) {
        this.selectedPopulationIdentifier = selectedId;
    }

    protected void setRVPTarget(Notifier target) {
        if (this.rvp == null) {
            this.rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt(target, RelativeValueProvider.class);
        } else {
            this.rvp.setTarget(target);
        }
    }

    @Override
    public STEMColor getBackgroundFillColor() {
        return this.backgroundFillColor;
    }

    public STEMColor getForegroundFillColor() {
        return this.foregroundFillColor;
    }

    @Override
    public STEMColor getBorderColor() {
        return this.borderColor;
    }

    public int getAlpha() {
        return this.alpha;
    }

    protected float performGainAndLogScaling(float v, float gain, boolean logScaling) {
        double vDouble = v * gain;
        if (vDouble > 1.0) {
            vDouble = 1.0;
        } else if ((double)v < 0.0) {
            vDouble = 0.0;
        }
        if (!logScaling) {
            return (float)vDouble;
        }
        double vScaled100 = vDouble * 99.0;
        double newV = Math.log10(vScaled100 += 1.0);
        return (float)(newV /= 2.0);
    }
}

