/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class Debug {
    private final DebugTrace trace;
    private final String option;

    private Debug(DebugTrace trace, String option) {
        this.trace = trace;
        this.option = option;
    }

    public static Debug getDebug(String name) {
        ServiceReference ref;
        BundleContext ctx;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        DebugTrace trace = null;
        Bundle bundle = FrameworkUtil.getBundle(Activator.class);
        if (bundle != null && (ctx = bundle.getBundleContext()) != null && (ref = ctx.getServiceReference(DebugOptions.class)) != null) {
            DebugOptions options = (DebugOptions)ctx.getService(ref);
            if (options.isDebugEnabled() && options.getBooleanOption("org.eclipse.pde.ds.annotations" + name, false)) {
                trace = options.newDebugTrace("org.eclipse.pde.ds.annotations");
            }
            ctx.ungetService(ref);
        }
        return new Debug(trace, name);
    }

    public boolean isDebugging() {
        return this.trace != null;
    }

    public void trace(String message) {
        if (this.trace != null) {
            this.trace.trace(this.option, message);
        }
    }

    public void trace(String message, Throwable error) {
        if (this.trace != null) {
            this.trace.trace(message, message, error);
        }
    }

    public void traceDumpStack() {
        if (this.trace != null) {
            this.trace.traceDumpStack(this.option);
        }
    }

    public void traceEntry() {
        if (this.trace != null) {
            this.trace.traceEntry(this.option);
        }
    }

    public void traceEntry(Object methodArgument) {
        if (this.trace != null) {
            this.trace.traceEntry(this.option, methodArgument);
        }
    }

    public void traceEntry(Object[] methodArguments) {
        if (this.trace != null) {
            this.trace.traceEntry(this.option, methodArguments);
        }
    }

    public void traceExit() {
        if (this.trace != null) {
            this.trace.traceExit(this.option);
        }
    }

    public void traceExit(Object result) {
        if (this.trace != null) {
            this.trace.traceExit(this.option, result);
        }
    }
}

