/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.transport.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.definitions.transport.PipeStyleTransportSystem;
import org.eclipse.stem.definitions.transport.TransportPackage;
import org.eclipse.stem.definitions.transport.provider.TransportSystemItemProvider;
import org.eclipse.stem.geography.names.GeographicNames;

public class PipeStyleTransportSystemItemProvider
extends TransportSystemItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public PipeStyleTransportSystemItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addInTransportEdgesPropertyDescriptor(object);
            this.addOutTransportEdgesPropertyDescriptor(object);
            this.addMaxCapacityPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addInTransportEdgesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PipeStyleTransportSystem_inTransportEdges_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PipeStyleTransportSystem_inTransportEdges_feature", "_UI_PipeStyleTransportSystem_type"), (EStructuralFeature)TransportPackage.Literals.PIPE_STYLE_TRANSPORT_SYSTEM__IN_TRANSPORT_EDGES, true, false, true, null, null, null));
    }

    protected void addOutTransportEdgesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PipeStyleTransportSystem_outTransportEdges_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PipeStyleTransportSystem_outTransportEdges_feature", "_UI_PipeStyleTransportSystem_type"), (EStructuralFeature)TransportPackage.Literals.PIPE_STYLE_TRANSPORT_SYSTEM__OUT_TRANSPORT_EDGES, true, false, true, null, null, null));
    }

    protected void addMaxCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PipeStyleTransportSystem_maxCapacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PipeStyleTransportSystem_maxCapacity_feature", "_UI_PipeStyleTransportSystem_type"), (EStructuralFeature)TransportPackage.Literals.PIPE_STYLE_TRANSPORT_SYSTEM__MAX_CAPACITY, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/custom16/airport.png"));
    }

    public String getTextGen(Object object) {
        URI labelValue = ((PipeStyleTransportSystem)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_PipeStyleTransportSystem_type") : String.valueOf(this.getString("_UI_PipeStyleTransportSystem_type")) + " " + label;
    }

    @Override
    public String getText(Object object) {
        PipeStyleTransportSystem system = (PipeStyleTransportSystem)object;
        URI labelURI = system.getURI();
        String lastSegment = labelURI.lastSegment().toString();
        String ISOKey = lastSegment;
        String geoName = GeographicNames.getName((String)ISOKey);
        StringBuilder sb = new StringBuilder(geoName.startsWith("!") ? ISOKey : geoName);
        sb.append(" " + system.getMaxCapacity());
        return sb.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PipeStyleTransportSystem.class)) {
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

