/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.custom.STextCharTypes;
import org.eclipse.equinox.bidi.custom.STextOffsets;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;
import org.eclipse.equinox.bidi.internal.STextActivator;

public class STextSql
extends STextTypeHandler {
    private static final byte WS = 12;
    static final String lineSep = STextActivator.getInstance().getProperty("line.separator");
    private static final Integer STATE_LITERAL = new Integer(2);
    private static final Integer STATE_SLASH_ASTER_COMMENT = new Integer(4);

    public STextSql() {
        super("\t!#%&()*+,-./:;<=>?|[]{}");
    }

    public int getSpecialsCount(ISTextExpert expert) {
        return 5;
    }

    public int indexOfSpecial(ISTextExpert expert, String text, STextCharTypes charTypes, STextOffsets offsets, int caseNumber, int fromIndex) {
        switch (caseNumber) {
            case 1: {
                return text.indexOf(" ", fromIndex);
            }
            case 2: {
                return text.indexOf(39, fromIndex);
            }
            case 3: {
                return text.indexOf(34, fromIndex);
            }
            case 4: {
                return text.indexOf("/*", fromIndex);
            }
            case 5: {
                return text.indexOf("--", fromIndex);
            }
        }
        return -1;
    }

    public int processSpecial(ISTextExpert expert, String text, STextCharTypes charTypes, STextOffsets offsets, int caseNumber, int separLocation) {
        STextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
        if (separLocation < 0) {
            caseNumber = (Integer)expert.getState();
            expert.clearState();
        }
        switch (caseNumber) {
            case 1: {
                ++separLocation;
                while (separLocation < text.length() && text.charAt(separLocation) == ' ') {
                    charTypes.setBidiTypeAt(separLocation, (byte)12);
                    ++separLocation;
                }
                return separLocation;
            }
            case 2: {
                int location = separLocation + 1;
                while (true) {
                    if ((location = text.indexOf(39, location)) < 0) {
                        expert.setState(STATE_LITERAL);
                        return text.length();
                    }
                    if (location + 1 >= text.length() || text.charAt(location + 1) != '\'') break;
                    location += 2;
                }
                return location + 1;
            }
            case 3: {
                int location = separLocation + 1;
                while (true) {
                    if ((location = text.indexOf(34, location)) < 0) {
                        return text.length();
                    }
                    if (location + 1 >= text.length() || text.charAt(location + 1) != '\"') break;
                    location += 2;
                }
                return location + 1;
            }
            case 4: {
                int location = separLocation < 0 ? 0 : separLocation + 2;
                location = text.indexOf("*/", location);
                if (location < 0) {
                    expert.setState(STATE_SLASH_ASTER_COMMENT);
                    return text.length();
                }
                STextTypeHandler.processSeparator(text, charTypes, offsets, location);
                return location + 2;
            }
            case 5: {
                int location = text.indexOf(lineSep, separLocation + 2);
                if (location < 0) {
                    return text.length();
                }
                return location + lineSep.length();
            }
        }
        return text.length();
    }
}

