/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DisplayAreaDialog
extends TitleAreaDialog {
    private Combo country = null;
    private Combo level = null;
    private Text search = null;
    Button clearButton = null;
    boolean rClear = false;

    public DisplayAreaDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setMessage("Enter Admin Area info.");
        this.setTitle("DisplayArea");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group1 = new Group(composite, 4);
        group1.setLayout((Layout)new RowLayout(256));
        Label countryLabel = new Label((Composite)group1, 0);
        countryLabel.setText("Country: ");
        this.country = new Combo((Composite)group1, 4);
        this.country.setTextLimit(3);
        String[] items = new String[]{"USA", "CAN", "MEX"};
        this.country.setItems(items);
        if (DisplayAreaData.rCountry != null) {
            this.country.setText(DisplayAreaData.rCountry);
        } else {
            this.country.select(0);
        }
        Label levelLabel = new Label((Composite)group1, 0);
        levelLabel.setText("Level: ");
        this.level = new Combo((Composite)group1, 12);
        items = new String[]{"0", "1", "2"};
        this.level.setTextLimit(1);
        this.level.setItems(items);
        this.level.select(Integer.parseInt(DisplayAreaData.rLevel));
        Label searchLabel = new Label(composite, 0);
        searchLabel.setText("Search text: ");
        this.search = new Text(composite, 2048);
        this.search.setTextLimit(48);
        if (DisplayAreaData.rSearch != null) {
            String searcharg = DisplayAreaData.rSearch;
            if (searcharg.length() < 10) {
                searcharg = String.valueOf(searcharg) + "         ";
            }
            this.search.setText(searcharg);
        }
        Group group2 = new Group(composite, 4);
        group2.setLayout((Layout)new RowLayout(256));
        this.clearButton = new Button((Composite)group2, 32);
        this.clearButton.setText("Clear Map");
        return composite;
    }

    public void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, "Apply", false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int id) {
        this.setReturnCode(id);
        GELog.debug((Object)this, "" + id);
        this.close();
    }

    public boolean close() {
        DisplayAreaData.rCountry = this.country.getText();
        DisplayAreaData.rLevel = this.level.getText();
        DisplayAreaData.rSearch = this.search.getText();
        this.rClear = this.clearButton.getSelection();
        return super.close();
    }

    public String getAdminFile() {
        String rCountry = DisplayAreaData.rCountry;
        GELog.debug((Object)this, rCountry);
        String adminFile = String.valueOf(rCountry) + "/" + rCountry + "_" + DisplayAreaData.rLevel + "_MAP.xml";
        return adminFile;
    }

    public String getSearch() {
        return DisplayAreaData.rSearch;
    }

    public boolean isClear() {
        return this.rClear;
    }

    public static class DisplayAreaData {
        public static String rLevel = "2";
        public static String rCountry = "USA";
        public static String rSearch = null;
    }
}

