/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.util.LiteralHelper;

public class TriggerSupportMatrix {
    protected static final int SVG = 1;
    protected static final int SWING = 2;
    protected static final int ALL = 127;
    public static final int TYPE_DATAPOINT = 1;
    public static final int TYPE_CHARTTITLE = 2;
    public static final int TYPE_CHARTAREA = 4;
    public static final int TYPE_AXIS = 8;
    public static final int TYPE_LEGEND = 16;
    public static final int TYPE_MARKERLINE = 32;
    public static final int TYPE_MARKERRANGE = 64;
    private static final int TYPE_ALL = 127;
    private static final int VALID_TYPES_HIGHLIGHT = 25;
    private static final int VALID_TYPES_TOOGLE_VISIBILITY = 27;
    private static final int VALID_TYPES_TOOGLE_DP_VISIBILITY = 1;
    protected static List<TriggerCombination> supportedTriggers = new ArrayList<TriggerCombination>();
    protected int iRenderer;
    protected final int iType;

    static {
        TriggerSupportMatrix.addTriggersLikeOnclick(TriggerCondition.ONCLICK_LITERAL);
        TriggerSupportMatrix.addTriggersLikeOnclick(TriggerCondition.ONDBLCLICK_LITERAL);
        TriggerSupportMatrix.addTriggersLikeOnclick(TriggerCondition.ONFOCUS_LITERAL);
        TriggerSupportMatrix.addTriggersLikeOnclick(TriggerCondition.ONBLUR_LITERAL);
        supportedTriggers.add(new TriggerCombination(TriggerCondition.ONMOUSEOVER_LITERAL, ActionType.SHOW_TOOLTIP_LITERAL, 2));
        supportedTriggers.add(new TriggerCombination(TriggerCondition.ONMOUSEOVER_LITERAL, ActionType.INVOKE_SCRIPT_LITERAL, 2));
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONMOUSEOVER_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONMOUSEDOWN_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONMOUSEUP_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONMOUSEMOVE_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONMOUSEOUT_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONKEYDOWN_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONKEYUP_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONKEYPRESS_LITERAL);
        TriggerSupportMatrix.addTriggersLikeMouseDown(TriggerCondition.ONLOAD_LITERAL);
    }

    private static void addTriggersLikeOnclick(TriggerCondition condition) {
        supportedTriggers.add(new TriggerCombination(condition, ActionType.URL_REDIRECT_LITERAL));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.INVOKE_SCRIPT_LITERAL));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.SHOW_TOOLTIP_LITERAL, 1));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.HIGHLIGHT_LITERAL, 1, 25));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.TOGGLE_VISIBILITY_LITERAL, 1, 27));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, 1, 1));
    }

    private static void addTriggersLikeMouseDown(TriggerCondition condition) {
        supportedTriggers.add(new TriggerCombination(condition, ActionType.URL_REDIRECT_LITERAL, 1));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.SHOW_TOOLTIP_LITERAL, 1));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.INVOKE_SCRIPT_LITERAL, 1));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.HIGHLIGHT_LITERAL, 1, 25));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.TOGGLE_VISIBILITY_LITERAL, 1, 27));
        supportedTriggers.add(new TriggerCombination(condition, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, 1, 1));
    }

    public TriggerSupportMatrix(String outputFormat, int iInteractivityType) {
        this.iRenderer = "SVG".equalsIgnoreCase(outputFormat) ? 1 : 2;
        this.iType = iInteractivityType;
    }

    public int getType() {
        return this.iType;
    }

    public String[] getSupportedActionsDisplayName(TriggerCondition condition) {
        ArrayList<String> actions = new ArrayList<String>();
        for (TriggerCombination tc : supportedTriggers) {
            if (!tc.test(condition, this.iRenderer, this.iType)) continue;
            actions.add(LiteralHelper.actionTypeSet.getDisplayNameByName(tc.getActionType().getName()));
        }
        return actions.toArray(new String[actions.size()]);
    }

    public boolean check(Trigger trigger) {
        if (trigger != null) {
            return this.check(trigger.getCondition(), trigger.getAction().getType());
        }
        return false;
    }

    public boolean check(TriggerCondition condition, ActionType actionType) {
        int i = 0;
        while (i < supportedTriggers.size()) {
            TriggerCombination tc = supportedTriggers.get(i);
            if (tc.test(condition, this.iRenderer, this.iType) && tc.getActionType() == actionType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TriggerCondition[] getConditionFilters() {
        return null;
    }

    public CursorType[] getCursorFilters() {
        return null;
    }

    protected static class TriggerCombination {
        private final TriggerCondition condition;
        private final ActionType actionType;
        private final int renderer;
        private final int type;

        public TriggerCombination(TriggerCondition condition, ActionType actionType) {
            this(condition, actionType, 127, 127);
        }

        public TriggerCombination(TriggerCondition condition, ActionType actionType, int iRenderer) {
            this(condition, actionType, iRenderer, 127);
        }

        public TriggerCombination(TriggerCondition tCondition, ActionType actionType, int iRenderer, int iType) {
            this.condition = tCondition;
            this.actionType = actionType;
            this.renderer = iRenderer;
            this.type = iType;
        }

        public boolean test(TriggerCondition tCondition, int iRenderer, int iType) {
            return this.condition == tCondition && (this.renderer & iRenderer) == iRenderer && (this.type & iType) == iType;
        }

        public ActionType getActionType() {
            return this.actionType;
        }
    }
}

