/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core;

import java.util.ArrayList;
import org.eclipse.stem.core.CorePlugin;

public abstract class STEMObjectPool {
    ArrayList<Object> freeObjects = new ArrayList();
    int growthInc;

    public STEMObjectPool(int initialSize, int growthIncrement) {
        this.growthInc = growthIncrement <= 0 ? 1 : growthIncrement;
        try {
            int i = 0;
            while (i < initialSize) {
                this.freeObjects.add(this.createNewObject());
                ++i;
            }
        }
        catch (Exception e) {
            CorePlugin.logError("Error growing STEM object pool", e);
        }
    }

    public synchronized Object get() {
        if (this.freeObjects.size() > 0) {
            return this.freeObjects.remove(this.freeObjects.size() - 1);
        }
        try {
            int i = 0;
            while (i < this.growthInc) {
                this.freeObjects.add(this.createNewObject());
                ++i;
            }
        }
        catch (Exception e) {
            CorePlugin.logError("Error growing STEM object pool", e);
        }
        return this.freeObjects.remove(this.freeObjects.size() - 1);
    }

    public synchronized void release(Object o) {
        this.freeObjects.add(o);
    }

    protected abstract Object createNewObject();
}

