/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.SimpleGraphPartitioner;
import org.eclipse.stem.core.graph.impl.GraphPartitionerImpl;
import org.eclipse.stem.core.model.Decorator;

public class SimpleGraphPartitionerImpl
extends GraphPartitionerImpl
implements SimpleGraphPartitioner {
    protected Map<Decorator, Map<Integer, EList<DynamicLabel>>> labelPartitionMap = new HashMap<Decorator, Map<Integer, EList<DynamicLabel>>>();

    protected SimpleGraphPartitionerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GraphPackage.Literals.SIMPLE_GRAPH_PARTITIONER;
    }

    @Override
    public void setNumProcesses(int newNumProcesses) {
        if (this.getNumProcesses() != newNumProcesses) {
            this.labelPartitionMap.clear();
        }
        super.setNumProcesses(newNumProcesses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EList<DynamicLabel> partitionDecoratorLabels(Decorator decorator, int processRank) {
        Map<Decorator, Map<Integer, EList<DynamicLabel>>> map = this.labelPartitionMap;
        synchronized (map) {
            if (this.labelPartitionMap != null && this.labelPartitionMap.containsKey(decorator) && this.labelPartitionMap.get(decorator).containsKey(processRank)) {
                EList<DynamicLabel> res = this.labelPartitionMap.get(decorator).get(processRank);
                return res;
            }
            BasicEList temp = new BasicEList();
            TreeSet<String> nodeURIs = new TreeSet<String>();
            for (DynamicLabel lab : decorator.getLabelsToUpdate()) {
                String uri = lab.getIdentifiable().getURI().toString();
                if (nodeURIs.contains(uri)) continue;
                nodeURIs.add(uri);
            }
            TreeSet<String> myURIs = new TreeSet<String>();
            for (String uri : nodeURIs) {
                if (Math.abs(uri.hashCode() % this.getNumProcesses()) != processRank) continue;
                myURIs.add(uri);
            }
            for (DynamicLabel dl : decorator.getLabelsToUpdate()) {
                if (!myURIs.contains(dl.getIdentifiable().getURI().toString())) continue;
                temp.add((Object)dl);
            }
            Map<Object, Object> partitionMap = null;
            if (this.labelPartitionMap.containsKey(decorator)) {
                partitionMap = this.labelPartitionMap.get(decorator);
            } else {
                partitionMap = new HashMap();
                this.labelPartitionMap.put(decorator, partitionMap);
            }
            partitionMap.put(processRank, temp);
            return temp;
        }
    }

    @Override
    public EList<DynamicLabel> partitionDecoratorLabels(Decorator decorator) {
        return decorator.getLabelsToUpdate();
    }

    @Override
    public boolean isManaged(Identifiable identifiable) {
        return true;
    }
}

