/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.provider;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.adapters.history.HistoryExtendedListener;
import org.eclipse.stem.adapters.history.HistoryProvider;
import org.eclipse.stem.adapters.history.HistoryProviderAdapter;
import org.eclipse.stem.adapters.history.HistoryProviderAdapterFactory;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.util.StandardAdapterFactory;

public class StandardRelativeValueHistoryProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueHistoryProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private HistoryProviderAdapter historyProviderAdapter = null;

    public StandardRelativeValueHistoryProviderAdapterFactory() {
        RelativeValueHistoryProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    @Override
    public Adapter createAdapter(Notifier target) {
        Adapter retValue = null;
        this.historyProviderAdapter = (HistoryProviderAdapter)HistoryProviderAdapterFactory.INSTANCE.adapt(target, HistoryProvider.class);
        if (this.historyProviderAdapter != null) {
            retValue = super.createAdapter(target);
        }
        return retValue;
    }

    @Override
    public Adapter createPopulationModelLabelAdapter() {
        return new PopulationModelLabelRelativeValueHistoryProvider(this.historyProviderAdapter);
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type == RelativeValueHistoryProvider.class || super.isFactoryForType(type);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    public static class PopulationModelLabelRelativeValueHistoryProvider
    extends RelativeValueHistoryProviderAdapter
    implements RelativeValueHistoryProvider {
        private HistoryProviderAdapter historyProviderAdapter = null;

        public PopulationModelLabelRelativeValueHistoryProvider(HistoryProviderAdapter historyProviderAdapter) {
            this.historyProviderAdapter = historyProviderAdapter;
            historyProviderAdapter.addExtensionListener((HistoryExtendedListener)this);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            PopulationModelLabel dml = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueHistoryProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)dml.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            PopulationModelLabel dml = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueHistoryProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)dml.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return 1.0;
        }

        public double getRelativeValue(ItemPropertyDescriptor property, STEMTime time) {
            return this.getRelativeValue((EStructuralFeature)property.getFeature(null), time);
        }

        public double getRelativeValue(EStructuralFeature feature, STEMTime time) {
            this.historyProviderAdapter.setTarget(this.getTarget());
            PopulationModelLabel dml = (PopulationModelLabel)this.historyProviderAdapter.getInstance(time);
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dml, RelativeValueProvider.class);
            return rvp.getRelativeValue(feature);
        }

        public double[] getAllHistoricRelativeValues(ItemPropertyDescriptor property) {
            return this.getAllHistoricRelativeValues((EStructuralFeature)property.getFeature(null));
        }

        public double[] getAllHistoricRelativeValues(EStructuralFeature feature) {
            this.historyProviderAdapter.setTarget(this.getTarget());
            Identifiable[] historicValues = this.historyProviderAdapter.getAllHistoricInstances();
            double[] retValue = new double[historicValues.length];
            int i = 0;
            Identifiable[] identifiableArray = historicValues;
            int n = historicValues.length;
            int n2 = 0;
            while (n2 < n) {
                Identifiable identifiable = identifiableArray[n2];
                PopulationModelLabel dml = (PopulationModelLabel)identifiable;
                RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dml, RelativeValueProvider.class);
                retValue[i++] = rvp.getRelativeValue(feature);
                ++n2;
            }
            return retValue;
        }

        public double[] getHistoricInstances(ItemPropertyDescriptor property, STEMTime[] timeRange) {
            double[] allValues = this.getAllHistoricRelativeValues(property);
            double[] retVal = new double[timeRange.length];
            System.arraycopy(allValues, 0, retVal, 0, timeRange.length);
            return retVal;
        }

        public STEMTime getEarliestTimeValue() {
            this.historyProviderAdapter.setTarget(this.getTarget());
            return this.historyProviderAdapter.getEarliestTimeValue();
        }

        public STEMTime[] getAllHistoricTimeValues() {
            this.historyProviderAdapter.setTarget(this.getTarget());
            return this.historyProviderAdapter.getAllHistoricTimeValues();
        }
    }
}

