/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.proxy;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.proxy.IClientStateManager;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyConnection;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoderFactory;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.internal.httpproxy.HTTPProxy;
import org.eclipse.actf.util.internal.httpproxy.core.ClientConnection;
import org.eclipse.actf.util.internal.httpproxy.core.ServerConnection;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPRequestDispatcher;

public class HTTPProxyConnection
extends ClientConnection
implements IHTTPProxyConnection {
    private final HTTPProxy fProxy;
    private final int timeout;

    HTTPProxy getProxy() {
        return this.fProxy;
    }

    public ISecretManager getSecretManager() {
        return this.fProxy.getSecretManager();
    }

    ExternalProxyConfig getExternalProxyConfig() {
        return this.fProxy.getExternalProxyConfig();
    }

    public int getListenPort() {
        return this.fProxy.getListenPort();
    }

    void notifySuccessfulServerConnection(ServerConnection serverConnection) {
    }

    public void init(IClientStateManager iClientStateManager, Socket socket, long l, int n) throws IOException {
        this.setConnectionName("[id:" + socket.getPort() + "] HTTPProxyConnection");
        HTTPRequestDispatcher hTTPRequestDispatcher = new HTTPRequestDispatcher(this, iClientStateManager, socket, this.getQueueSize(), this.timeout);
        IHTTPProxyTranscoderFactory iHTTPProxyTranscoderFactory = this.fProxy.getProxyTranscoderFactory();
        if (iHTTPProxyTranscoderFactory != null) {
            hTTPRequestDispatcher.setTranscoder(iHTTPProxyTranscoderFactory.newInstance(hTTPRequestDispatcher.getDispatcherId()));
        }
        this.initInternal(socket, l, this.timeout, hTTPRequestDispatcher);
    }

    public HTTPProxyConnection(HTTPProxy hTTPProxy, int n, int n2) {
        super(hTTPProxy, n);
        this.fProxy = hTTPProxy;
        this.timeout = n2;
    }
}

