/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tid;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.ActiveTidStateProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TidAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.kernel.tid";
    private final Map<Integer, ITmfStateInterval> fCache = new HashMap<Integer, ITmfStateInterval>();
    private static final @NonNull Set<@NonNull TmfAbstractAnalysisRequirement> REQUIREMENTS = Collections.emptySet();

    public @NonNull Iterable<@NonNull TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return REQUIREMENTS;
    }

    public String getHelpText() {
        String msg = Messages.TidAnalysisModule_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public @NonNull String getHelpText(@NonNull ITmfTrace trace) {
        return this.getHelpText();
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        DefaultEventLayout layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        return new ActiveTidStateProvider(trace, layout);
    }

    public @Nullable Integer getThreadOnCpuAtTime(int cpu, long time) {
        int cpuQuark;
        long queryTime;
        Integer tid;
        ITmfStateSystem stateSystem;
        block6: {
            stateSystem = this.getStateSystem();
            if (stateSystem == null || time < stateSystem.getStartTime()) {
                return null;
            }
            tid = null;
            queryTime = Math.max(time - 1L, stateSystem.getStartTime());
            cpuQuark = stateSystem.optQuarkAbsolute(new String[]{Integer.toString(cpu)});
            if (cpuQuark != -2) break block6;
            return null;
        }
        try {
            Object value;
            ITmfStateInterval state = this.fCache.get(cpuQuark);
            if (state == null || !state.intersects(queryTime)) {
                state = stateSystem.querySingleState(queryTime, cpuQuark);
                this.fCache.put(cpuQuark, state);
            }
            if ((value = state.getValue()) instanceof Integer) {
                tid = (Integer)value;
            }
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Activator.getDefault().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), e);
        }
        return tid;
    }

    public @Nullable Integer getCpuForTidAtTime(int tid, long time) {
        ITmfStateSystem stateSystem = this.getStateSystem();
        if (stateSystem == null) {
            return null;
        }
        try {
            for (ITmfStateInterval interval : stateSystem.queryFullState(time)) {
                if (tid != interval.getStateValue().unboxInt()) continue;
                return Integer.parseInt(stateSystem.getAttributeName(interval.getAttribute()));
            }
        }
        catch (StateSystemDisposedException e) {
            Activator.getDefault().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), e);
        }
        return null;
    }
}

