/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.ActivatorTest;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallGraphAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregationTreeTest {
    private static final String CALLSTACK_FILE = "testfiles/traces/callstack.xml";
    private static final String FIRST_FUNCTION = "Children number: First function";
    private static final String FIRST_FUNCTION_DURATION = "Test first function's duration";
    private static final String FIRST_FUNCTION_NUMBER_OF_CALLS = "Test first function's number of calls";
    private static final String FIRST_FUNCTION_SELF_TIME = "Test first function's self time";
    private static final String SECOND_FUNCTION = "Children number: Second function";
    private static final String SECOND_FUNCTION_DURATION = "Test second function's duration";
    private static final String SECOND_FUNCTION_NUMBER_OF_CALLS = "Test second function's number of calls";
    private static final String SECOND_FUNCTION_SELF_TIME = "Test second function's self time";
    private static final String THIRD_FUNCTION = "Children number: Third function";
    private static final String THIRD_FUNCTION_DURATION = "Test third function's duration";
    private static final String THIRD_FUNCTION_NUMBER_OF_CALLS = "Test third function's number of calls";
    private static final String THIRD_FUNCTION_SELF_TIME = "Test third function's self time";
    private static final String THREAD = "Thread";
    private static final String THREAD_NAME = "Thread name";
    private static final String THREAD_NODES_FOUND = "Number of thread nodes found";
    private static final String ROOT_FUNCTIONS = "Number of root functions";
    private ITmfTrace fTrace;
    private static final String QUARK_0 = "0";
    private static final String QUARK_1 = "1";
    private static final String QUARK_2 = "2";
    private static final String QUARK_3 = "3";
    private static final Integer SMALL_AMOUNT_OF_SEGMENT = 3;
    private static final int LARGE_AMOUNT_OF_SEGMENTS = 1000;
    private CallGraphAnalysisStub fCga;

    private static @NonNull ITmfStateSystemBuilder createFixture() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"Test", (long)0L);
        return StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
    }

    private static List<ICallStackElement> getLeafElements(ICallStackElement group) {
        if (group.isLeaf()) {
            return Collections.singletonList(group);
        }
        ArrayList<ICallStackElement> leafGroups = new ArrayList<ICallStackElement>();
        group.getChildrenElements().forEach(g -> {
            boolean bl = leafGroups.addAll(AggregationTreeTest.getLeafElements(g));
        });
        return leafGroups;
    }

    private static @NonNull List<ICallStackElement> getLeafElements(ICallGraphProvider2 cga) {
        Collection elements = cga.getCallGraph().getElements();
        ArrayList<ICallStackElement> leafGroups = new ArrayList<ICallStackElement>();
        for (ICallStackElement group : elements) {
            leafGroups.addAll(AggregationTreeTest.getLeafElements(group));
        }
        return leafGroups;
    }

    @Before
    public void before() {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        IPath filePath = ActivatorTest.getAbsoluteFilePath(CALLSTACK_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        this.fTrace = trace;
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null);
        trace.traceOpened(signal);
        TmfTraceManager.getInstance().traceOpened(signal);
    }

    @After
    public void after() {
        ModelManager.disposeModels();
    }

    @After
    public void disposeCga() {
        ITmfTrace trace;
        CallGraphAnalysisStub cga = this.fCga;
        if (cga != null) {
            cga.dispose();
        }
        if ((trace = this.fTrace) != null) {
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
            trace.dispose();
        }
    }

    @Test
    public void emptyStateSystemTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        fixture.closeHistory(1002L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)"Number of threads found", (long)0L, (long)threads.size());
    }

    @Test
    public void cascadeTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        long start = 1L;
        long end = 1001L;
        int threadQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", THREAD});
        int parentQuark = fixture.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
        fixture.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)100L), threadQuark);
        int i = 1;
        while (i <= SMALL_AMOUNT_OF_SEGMENT) {
            int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{Integer.toString(i)});
            long statev = i;
            fixture.modifyAttribute(start, null, quark);
            fixture.modifyAttribute(start + (long)i, (Object)statev, quark);
            fixture.modifyAttribute(end - (long)i, null, quark);
            ++i;
        }
        fixture.closeHistory(1002L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NODES_FOUND, (long)1L, (long)threads.size());
        ICallStackElement group = threads.get(0);
        CallGraph cg = cga.getCallGraph();
        Assert.assertNotNull((Object)group);
        Assert.assertEquals((String)ROOT_FUNCTIONS, (long)1L, (long)cg.getCallingContextTree(group).size());
        Assert.assertEquals((String)"Thread id", (Object)THREAD, (Object)group.getName());
        Object[] children = cg.getCallingContextTree(group).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)FIRST_FUNCTION, (long)1L, (long)firstFunction.getCallees().size());
        Object @NonNull [] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Assert.assertEquals((String)SECOND_FUNCTION, (long)1L, (long)secondFunction.getCallees().size());
        Object @NonNull [] secondFunctionChildren = secondFunction.getCallees().toArray();
        AggregatedCalledFunction thirdFunction = (AggregatedCalledFunction)secondFunctionChildren[0];
        Assert.assertEquals((String)THIRD_FUNCTION, (long)0L, (long)thirdFunction.getCallees().size());
        Assert.assertEquals((String)FIRST_FUNCTION_DURATION, (long)998L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)996L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)THIRD_FUNCTION_DURATION, (long)994L, (long)thirdFunction.getDuration());
        Assert.assertEquals((String)FIRST_FUNCTION_SELF_TIME, (long)2L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_SELF_TIME, (long)2L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)THIRD_FUNCTION_SELF_TIME, (long)994L, (long)thirdFunction.getSelfTime());
        Assert.assertEquals((String)"Test first function's nombre of calls", (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)"Test second function's nombre of calls", (long)1L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)"Test third function's nombre of calls", (long)1L, (long)thirdFunction.getNbCalls());
    }

    @Test
    public void treeTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int threadQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", THREAD});
        int parentQuark = fixture.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
        fixture.updateOngoingState((ITmfStateValue)TmfStateValue.newValueDouble((double)0.001), threadQuark);
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(90L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(30L, null, quark);
        fixture.closeHistory(102L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        @NonNull List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NODES_FOUND, (long)1L, (long)threads.size());
        Assert.assertEquals((String)THREAD_NAME, (Object)THREAD, (Object)threads.get(0).getName());
        Object[] children = cga.getCallGraph().getCallingContextTree(threads.get(0)).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)FIRST_FUNCTION, (long)1L, (long)firstFunction.getCallees().size());
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Assert.assertEquals((String)SECOND_FUNCTION, (long)1L, (long)secondFunction.getCallees().size());
        Object[] secondFunctionChildren = secondFunction.getCallees().toArray();
        AggregatedCalledFunction thirdFunction = (AggregatedCalledFunction)secondFunctionChildren[0];
        Assert.assertEquals((String)THIRD_FUNCTION, (long)0L, (long)thirdFunction.getCallees().size());
        Assert.assertEquals((String)FIRST_FUNCTION_DURATION, (long)100L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)80L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)THIRD_FUNCTION_DURATION, (long)30L, (long)thirdFunction.getDuration());
        Assert.assertEquals((String)FIRST_FUNCTION_SELF_TIME, (long)20L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_SELF_TIME, (long)50L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)THIRD_FUNCTION_SELF_TIME, (long)30L, (long)thirdFunction.getSelfTime());
        Assert.assertEquals((String)FIRST_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)SECOND_FUNCTION_NUMBER_OF_CALLS, (long)2L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)THIRD_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)thirdFunction.getNbCalls());
    }

    @Test
    public void mergeFirstLevelCalleesTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int threadQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", "123"});
        int parentQuark = fixture.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
        fixture.updateOngoingState((ITmfStateValue)TmfStateValue.newValueDouble((double)0.001), threadQuark);
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(90L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(30L, null, quark);
        statev = 3L;
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(80L, null, quark);
        fixture.closeHistory(102L);
        String[] tp = new String[]{"*"};
        String[] pp = new String[]{"Processes"};
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture, (List<String[]>)ImmutableList.of((Object)pp, (Object)tp));
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        CallGraph cg = cga.getCallGraph();
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NODES_FOUND, (long)1L, (long)threads.size());
        Assert.assertEquals((String)THREAD_NAME, (Object)"123", (Object)threads.get(0).getName());
        Assert.assertEquals((String)ROOT_FUNCTIONS, (long)1L, (long)cg.getCallingContextTree(threads.get(0)).size());
        Object[] children = cg.getCallingContextTree(threads.get(0)).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)FIRST_FUNCTION, (long)1L, (long)firstFunction.getCallees().size());
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Assert.assertEquals((String)SECOND_FUNCTION, (long)2L, (long)secondFunction.getCallees().size());
        AggregatedCalledFunction leaf1 = (AggregatedCalledFunction)secondFunction.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x2")).findAny().get();
        AggregatedCalledFunction leaf2 = (AggregatedCalledFunction)secondFunction.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x3")).findAny().get();
        Assert.assertEquals((String)"Children number: First leaf function", (long)0L, (long)leaf1.getCallees().size());
        Assert.assertEquals((String)"Children number: Second leaf function", (long)0L, (long)leaf2.getCallees().size());
        Assert.assertEquals((String)FIRST_FUNCTION_DURATION, (long)100L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)80L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)"Test first leaf's duration", (long)30L, (long)leaf1.getDuration());
        Assert.assertEquals((String)"Test second leaf's duration", (long)20L, (long)leaf2.getDuration());
        Assert.assertEquals((String)FIRST_FUNCTION_SELF_TIME, (long)20L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_SELF_TIME, (long)30L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)"Test first leaf's self time", (long)30L, (long)leaf1.getSelfTime());
        Assert.assertEquals((String)"Test second leaf's self time", (long)20L, (long)leaf2.getSelfTime());
        Assert.assertEquals((String)FIRST_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)SECOND_FUNCTION_NUMBER_OF_CALLS, (long)2L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)"Test first leaf's number of calls", (long)1L, (long)leaf1.getNbCalls());
        Assert.assertEquals((String)"Test second leaf's number of calls", (long)1L, (long)leaf2.getNbCalls());
    }

    private static void buildCallStack(ITmfStateSystemBuilder fixture) {
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", THREAD, "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        statev = 3L;
        fixture.modifyAttribute(20L, (Object)statev, quark);
        fixture.modifyAttribute(30L, null, quark);
        statev = 2L;
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(90L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_3});
        statev = 4L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(80L, null, quark);
        fixture.closeHistory(102L);
    }

    @Test
    public void mergeSecondLevelCalleesTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        AggregationTreeTest.buildCallStack(fixture);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        CallGraph cg = cga.getCallGraph();
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NODES_FOUND, (long)1L, (long)threads.size());
        Assert.assertEquals((String)THREAD_NAME, (Object)THREAD, (Object)threads.get(0).getName());
        Assert.assertEquals((String)ROOT_FUNCTIONS, (long)1L, (long)cg.getCallingContextTree(threads.get(0)).size());
        Object[] children = cg.getCallingContextTree(threads.get(0)).toArray();
        AggregatedCalledFunction main = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)"Children number: main", (long)1L, (long)main.getCallees().size());
        Object[] mainChildren = main.getCallees().toArray();
        AggregatedCalledFunction function1 = (AggregatedCalledFunction)mainChildren[0];
        Assert.assertEquals((String)"Children number: first function", (long)2L, (long)function1.getCallees().size());
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)function1.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x2")).findAny().get();
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)function1.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x3")).findAny().get();
        Assert.assertEquals((String)"Children number: First child", (long)1L, (long)function2.getCallees().size());
        Assert.assertEquals((String)"Children number: Second child", (long)0L, (long)function3.getCallees().size());
        Object[] firstChildCallee = function2.getCallees().toArray();
        AggregatedCalledFunction function4 = (AggregatedCalledFunction)firstChildCallee[0];
        Assert.assertEquals((String)"Children number: leaf function", (long)0L, (long)function4.getCallees().size());
        Assert.assertEquals((String)"Test main's duration", (long)100L, (long)main.getDuration());
        Assert.assertEquals((String)FIRST_FUNCTION_DURATION, (long)90L, (long)function1.getDuration());
        Assert.assertEquals((String)"Test first child's duration", (long)40L, (long)function2.getDuration());
        Assert.assertEquals((String)"Test second child's duration", (long)10L, (long)function3.getDuration());
        Assert.assertEquals((String)"Test leaf's duration", (long)30L, (long)function4.getDuration());
        Assert.assertEquals((String)"Test main's self time", (long)10L, (long)main.getSelfTime());
        Assert.assertEquals((String)FIRST_FUNCTION_SELF_TIME, (long)40L, (long)function1.getSelfTime());
        Assert.assertEquals((String)"Test first child's self time", (long)10L, (long)function2.getSelfTime());
        Assert.assertEquals((String)"Test second child's self time", (long)10L, (long)function3.getSelfTime());
        Assert.assertEquals((String)"Test leaf's self time", (long)30L, (long)function4.getSelfTime());
        Assert.assertEquals((String)"Test main's number of calls", (long)1L, (long)main.getNbCalls());
        Assert.assertEquals((String)FIRST_FUNCTION_NUMBER_OF_CALLS, (long)2L, (long)function1.getNbCalls());
        Assert.assertEquals((String)"Test first child's number of calls", (long)2L, (long)function2.getNbCalls());
        Assert.assertEquals((String)"Test second child's number of calls", (long)1L, (long)function3.getNbCalls());
        Assert.assertEquals((String)"Test leaf's number of calls", (long)2L, (long)function4.getNbCalls());
    }

    @Test
    public void largeTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", THREAD, "CallStack"});
        int i = 0;
        while (i < 1000) {
            Long statev = i;
            fixture.pushAttribute(0L, (Object)statev, parentQuark);
            ++i;
        }
        i = 0;
        while (i < 1000) {
            fixture.popAttribute(10L, parentQuark);
            ++i;
        }
        fixture.closeHistory(11L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NAME, (Object)THREAD, (Object)threads.get(0).getName());
        Object[] children = cga.getCallGraph().getCallingContextTree(threads.get(0)).toArray();
        AggregatedCalledFunction parent = (AggregatedCalledFunction)children[0];
        int i2 = 1;
        while (i2 < 1000) {
            AggregatedCalledFunction child;
            children = parent.getCallees().toArray();
            parent = child = (AggregatedCalledFunction)children[0];
            ++i2;
        }
    }

    @Test
    public void multiFunctionRootsTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", THREAD, "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(20L, null, quark);
        fixture.modifyAttribute(30L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        statev = 3L;
        fixture.modifyAttribute(30L, (Object)statev, quark);
        fixture.modifyAttribute(40L, null, quark);
        fixture.closeHistory(51L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        CallGraph cg = cga.getCallGraph();
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NODES_FOUND, (long)1L, (long)threads.size());
        ICallStackElement group = threads.get(0);
        Assert.assertNotNull((Object)group);
        Assert.assertEquals((String)"Thread id", (Object)THREAD, (Object)group.getName());
        Assert.assertEquals((String)ROOT_FUNCTIONS, (long)1L, (long)cg.getCallingContextTree(group).size());
        Object[] children = cg.getCallingContextTree(group).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Assert.assertEquals((String)FIRST_FUNCTION, (long)2L, (long)firstFunction.getCallees().size());
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[1];
        Assert.assertEquals((String)SECOND_FUNCTION, (long)0L, (long)function2.getCallees().size());
        Assert.assertEquals((String)THIRD_FUNCTION, (long)0L, (long)function3.getCallees().size());
        Assert.assertEquals((String)FIRST_FUNCTION_DURATION, (long)40L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)10L, (long)function2.getDuration());
        Assert.assertEquals((String)THIRD_FUNCTION_DURATION, (long)10L, (long)function3.getDuration());
        Assert.assertEquals((String)FIRST_FUNCTION_SELF_TIME, (long)20L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_SELF_TIME, (long)10L, (long)function2.getSelfTime());
        Assert.assertEquals((String)THIRD_FUNCTION_SELF_TIME, (long)10L, (long)function2.getSelfTime());
        Assert.assertEquals((String)FIRST_FUNCTION_NUMBER_OF_CALLS, (long)2L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)SECOND_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)function2.getNbCalls());
        Assert.assertEquals((String)THIRD_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)function3.getNbCalls());
    }

    @Test
    public void multiFunctionRootsSecondTest() {
        ITmfStateSystemBuilder fixture = AggregationTreeTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", THREAD, "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(20L, null, quark);
        statev = 1L;
        fixture.modifyAttribute(30L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        fixture.modifyAttribute(30L, (Object)statev, quark);
        fixture.modifyAttribute(40L, null, quark);
        fixture.closeHistory(51L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregationTreeTest.getLeafElements((ICallGraphProvider2)cga);
        CallGraph cg = cga.getCallGraph();
        Assert.assertNotNull(threads);
        Assert.assertEquals((String)THREAD_NODES_FOUND, (long)1L, (long)threads.size());
        Assert.assertEquals((String)THREAD_NAME, (Object)THREAD, (Object)threads.get(0).getName());
        Assert.assertEquals((String)ROOT_FUNCTIONS, (long)2L, (long)cg.getCallingContextTree(threads.get(0)).size());
        Object[] children = cg.getCallingContextTree(threads.get(0)).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)children[1];
        Assert.assertEquals((String)FIRST_FUNCTION, (long)1L, (long)firstFunction.getCallees().size());
        Assert.assertEquals((String)SECOND_FUNCTION, (long)1L, (long)secondFunction.getCallees().size());
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        Object[] secondFunctionChildren = secondFunction.getCallees().toArray();
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function4 = (AggregatedCalledFunction)secondFunctionChildren[0];
        Assert.assertEquals((String)"Children number: third function", (long)0L, (long)function3.getCallees().size());
        Assert.assertEquals((String)"Children number: fourth function", (long)0L, (long)function4.getCallees().size());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)20L, (long)firstFunction.getDuration());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)20L, (long)secondFunction.getDuration());
        Assert.assertEquals((String)"Test first leaf's duration", (long)10L, (long)function3.getDuration());
        Assert.assertEquals((String)"Test second leaf's duration", (long)10L, (long)function4.getDuration());
        Assert.assertEquals((String)FIRST_FUNCTION_SELF_TIME, (long)10L, (long)firstFunction.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_DURATION, (long)10L, (long)secondFunction.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_SELF_TIME, (long)10L, (long)function3.getSelfTime());
        Assert.assertEquals((String)SECOND_FUNCTION_SELF_TIME, (long)10L, (long)function4.getSelfTime());
        Assert.assertEquals((String)FIRST_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)firstFunction.getNbCalls());
        Assert.assertEquals((String)FIRST_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)secondFunction.getNbCalls());
        Assert.assertEquals((String)THIRD_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)function3.getNbCalls());
        Assert.assertEquals((String)THIRD_FUNCTION_NUMBER_OF_CALLS, (long)1L, (long)function4.getNbCalls());
    }

    protected CallGraphAnalysisStub getCga() {
        return this.fCga;
    }

    private void setCga(CallGraphAnalysisStub cga) {
        this.fCga = cga;
    }

    protected @NonNull ITmfTrace getTrace() {
        return Objects.requireNonNull(this.fTrace);
    }
}

