/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.xml;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.perf.XmlAnalysisPerfBenchmark;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LttngKernelXmlAnalysisBenchmark
extends XmlAnalysisPerfBenchmark {
    private final String fFileTracePath;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() throws IOException {
        return Arrays.asList({"syscall with many threads", 25, "syscallSegments.xml", "xml.syscall.cpu.time", FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.MANY_THREADS.getTraceURL())).getAbsolutePath()}, {"syscall with os_events", 10, "syscallSegments.xml", "xml.syscall.cpu.time", CtfBenchmarkTrace.ALL_OS_ANALYSES.getTracePath().toString()});
    }

    public LttngKernelXmlAnalysisBenchmark(String name, int loopCount, String xmlFileName, @NonNull String xmlAnalysisName, String testTrace) {
        super(name, Activator.getAbsoluteFilePath("testfiles/xml/" + xmlFileName).toOSString(), xmlAnalysisName, loopCount);
        this.fFileTracePath = testTrace;
    }

    protected ITmfTrace getTrace() throws TmfTraceException {
        LttngKernelTrace trace = new LttngKernelTrace();
        try {
            trace.initTrace(null, this.fFileTracePath, CtfTmfEvent.class);
            return trace;
        }
        catch (TmfTraceException e) {
            trace.dispose();
            throw e;
        }
    }
}

