/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VoidHandler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.net.NetSocket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class HttpClientResponseImpl
implements HttpClientResponse {
    private final int statusCode;
    private final String statusMessage;
    private final HttpClientRequestImpl request;
    private final Vertx vertx;
    private final ClientConnection conn;
    private final HttpResponse response;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private LastHttpContent trailer;
    private boolean paused;
    private Queue<Buffer> pausedChunks;
    private boolean hasPausedEnd;
    private LastHttpContent pausedTrailer;
    private NetSocket netSocket;
    private long bytesRead;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    HttpClientResponseImpl(Vertx vertx, HttpClientRequestImpl request, ClientConnection conn, HttpResponse response) {
        this.vertx = vertx;
        this.statusCode = response.getStatus().code();
        this.statusMessage = response.getStatus().reasonPhrase();
        this.request = request;
        this.conn = conn;
        this.response = response;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HeadersAdaptor(this.response.headers());
        }
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public synchronized MultiMap trailers() {
        if (this.trailers == null) {
            this.trailers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders());
        }
        return this.trailers;
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers.get(trailerName);
    }

    @Override
    public synchronized List<String> cookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<String>();
            this.cookies.addAll(this.response.headers().getAll(HttpHeaders.SET_COOKIE));
            if (this.trailer != null) {
                this.cookies.addAll(this.trailer.trailingHeaders().getAll(HttpHeaders.SET_COOKIE));
            }
        }
        return this.cookies;
    }

    @Override
    public synchronized HttpClientResponse handler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
        return this;
    }

    @Override
    public synchronized HttpClientResponse endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized HttpClientResponse exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public synchronized HttpClientResponse pause() {
        this.paused = true;
        this.conn.doPause();
        return this;
    }

    @Override
    public synchronized HttpClientResponse resume() {
        this.paused = false;
        this.doResume();
        this.conn.doResume();
        return this;
    }

    @Override
    public HttpClientResponse bodyHandler(final Handler<Buffer> bodyHandler) {
        final BodyHandler handler = new BodyHandler();
        this.handler((Handler)handler);
        this.endHandler((Handler)new VoidHandler(){

            @Override
            public void handle() {
                handler.notifyHandler(bodyHandler);
            }
        });
        return this;
    }

    private void doResume() {
        if (this.pausedChunks != null) {
            Buffer chunk;
            while ((chunk = this.pausedChunks.poll()) != null) {
                final Buffer theChunk = chunk;
                this.vertx.runOnContext(new VoidHandler(){

                    @Override
                    protected void handle() {
                        HttpClientResponseImpl.this.handleChunk(theChunk);
                    }
                });
            }
        }
        if (this.hasPausedEnd) {
            final LastHttpContent theTrailer = this.pausedTrailer;
            this.vertx.runOnContext(new VoidHandler(){

                @Override
                protected void handle() {
                    HttpClientResponseImpl.this.handleEnd(theTrailer);
                }
            });
            this.hasPausedEnd = false;
            this.pausedTrailer = null;
        }
    }

    synchronized void handleChunk(Buffer data) {
        this.bytesRead += (long)data.length();
        if (this.paused) {
            if (this.pausedChunks == null) {
                this.pausedChunks = new ArrayDeque<Buffer>();
            }
            this.pausedChunks.add(data);
        } else {
            this.request.dataReceived();
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        }
    }

    synchronized void handleEnd(LastHttpContent trailer) {
        this.conn.reportBytesRead(this.bytesRead);
        this.bytesRead = 0L;
        this.request.reportResponseEnd(this);
        if (this.paused) {
            this.hasPausedEnd = true;
            this.pausedTrailer = trailer;
        } else {
            this.trailer = trailer;
            this.trailers = new HeadersAdaptor(trailer.trailingHeaders());
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    synchronized void handleException(Throwable e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }

    @Override
    public synchronized NetSocket netSocket() {
        if (this.netSocket == null) {
            this.netSocket = this.conn.createNetSocket();
        }
        return this.netSocket;
    }

    private static final class BodyHandler
    implements Handler<Buffer> {
        private Buffer body;

        private BodyHandler() {
        }

        @Override
        public void handle(Buffer event) {
            this.body().appendBuffer(event);
        }

        private Buffer body() {
            if (this.body == null) {
                this.body = Buffer.buffer();
            }
            return this.body;
        }

        void notifyHandler(Handler<Buffer> bodyHandler) {
            bodyHandler.handle(this.body());
            this.body = null;
        }
    }
}

