/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.impl.Arguments;
import io.vertx.core.net.SocketAddress;
import java.util.Objects;

public class SocketAddressImpl
implements SocketAddress {
    private final String hostAddress;
    private final int port;

    public SocketAddressImpl(int port, String host) {
        Objects.requireNonNull(host, "no null host accepted");
        Arguments.require(!host.isEmpty(), "no empty host accepted");
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        this.port = port;
        this.hostAddress = host;
    }

    @Override
    public String host() {
        return this.hostAddress;
    }

    @Override
    public int port() {
        return this.port;
    }

    public String toString() {
        return this.hostAddress + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketAddressImpl that = (SocketAddressImpl)o;
        if (this.port != that.port) {
            return false;
        }
        return !(this.hostAddress != null ? !this.hostAddress.equals(that.hostAddress) : that.hostAddress != null);
    }

    public int hashCode() {
        int result = this.hostAddress != null ? this.hostAddress.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

