/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.compiler.task;

import java.util.List;
import org.eclipse.dltk.mod.compiler.task.ITaskReporter;
import org.eclipse.dltk.mod.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.mod.compiler.task.TodoTask;

public class TodoTaskSimpleParser {
    private final boolean caseSensitive;
    private final char[][] tags;
    private final int minTagLength;
    private final int[] priorities;
    private int lineNumber;
    private int contentPos;
    private int contentEnd;

    public TodoTaskSimpleParser(ITodoTaskPreferences preferences) {
        this.caseSensitive = preferences.isCaseSensitive();
        List tags = preferences.getTaskTags();
        if (!tags.isEmpty()) {
            int tagCount = tags.size();
            this.tags = new char[tagCount][];
            this.priorities = new int[tagCount];
            int minTagLength = Integer.MAX_VALUE;
            int i = 0;
            while (i < tagCount) {
                TodoTask task = (TodoTask)tags.get(i);
                String tagName = task.name;
                if (!this.caseSensitive) {
                    tagName = tagName.toUpperCase();
                }
                if (tagName.length() < minTagLength) {
                    minTagLength = tagName.length();
                }
                this.tags[i] = tagName.toCharArray();
                this.priorities[i] = "HIGH".equals(task.priority) ? 2 : ("LOW".equals(task.priority) ? 0 : 1);
                ++i;
            }
            this.minTagLength = minTagLength;
        } else {
            this.tags = null;
            this.minTagLength = 0;
            this.priorities = null;
        }
    }

    public boolean isValid() {
        return this.tags != null && this.tags.length > 0;
    }

    public void parse(ITaskReporter reporter, char[] content) {
        this.lineNumber = 0;
        this.contentPos = 0;
        this.contentEnd = content.length;
        while (this.contentPos < this.contentEnd) {
            int begin = this.contentPos;
            int end = this.findEndOfLine(content);
            if (end == 137) {
                System.out.println();
            }
            if (begin < end && (begin = this.findCommentStart(content, begin, end)) > 0 && (begin = TodoTaskSimpleParser.skipSpaces(content, begin, end)) + this.minTagLength <= end) {
                this.processLine(reporter, content, begin, end);
            }
            ++this.lineNumber;
        }
    }

    protected int findCommentStart(char[] content, int begin, int end) {
        if ((begin = TodoTaskSimpleParser.skipSpaces(content, begin, end)) < end && content[begin] == '#') {
            return begin + 1;
        }
        return -1;
    }

    protected static int skipSpaces(char[] content, int pos, int end) {
        while (pos < end && Character.isWhitespace(content[pos])) {
            ++pos;
        }
        return pos;
    }

    private void processLine(ITaskReporter reporter, char[] content, int begin, int end) {
        int i = 0;
        while (i < this.tags.length) {
            char[] tag = this.tags[i];
            if (begin + tag.length <= end && this.compareTag(content, begin, end, tag)) {
                String msg = new String(content, begin, end - begin);
                reporter.reportTask(msg, this.lineNumber, this.priorities[i], begin, end);
            }
            ++i;
        }
    }

    private boolean compareTag(char[] content, int pos, int end, char[] tag) {
        int tagLen = tag.length;
        if (this.caseSensitive) {
            int j = 0;
            while (j < tagLen) {
                if (content[pos + j] != tag[j]) {
                    return false;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < tagLen) {
                if (Character.toUpperCase(content[pos + j]) != tag[j]) {
                    return false;
                }
                ++j;
            }
        }
        return pos + tagLen >= end || !Character.isJavaIdentifierPart(tag[tagLen - 1]) || !Character.isJavaIdentifierPart(content[pos + tagLen]);
    }

    private int findEndOfLine(char[] content) {
        while (this.contentPos < this.contentEnd) {
            if (content[this.contentPos] == '\r') {
                int endLine = this.contentPos++;
                if (this.contentPos < this.contentEnd && content[this.contentPos] == '\n') {
                    ++this.contentPos;
                }
                return endLine;
            }
            if (content[this.contentPos] == '\n') {
                int endLine = this.contentPos++;
                return endLine;
            }
            ++this.contentPos;
        }
        return this.contentPos;
    }
}

