/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProblemRequestor;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElementDelta;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.SourceModule;

public class BecomeWorkingCopyOperation
extends ModelOperation {
    IProblemRequestor problemRequestor;

    public BecomeWorkingCopyOperation(SourceModule workingCopy, IProblemRequestor problemRequestor) {
        super(new IModelElement[]{workingCopy});
        this.problemRequestor = problemRequestor;
    }

    @Override
    protected void executeOperation() throws ModelException {
        SourceModule workingCopy = this.getWorkingCopy();
        ModelManager.getModelManager().getPerWorkingCopyInfo(workingCopy, true, true, this.problemRequestor);
        workingCopy.openWhenClosed(workingCopy.createElementInfo(), this.progressMonitor);
        if (!workingCopy.isPrimary()) {
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            delta.added(workingCopy);
            this.addDelta(delta);
        } else if (workingCopy.getResource().isAccessible()) {
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            delta.changed(workingCopy, 65536);
            this.addDelta(delta);
        } else {
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            delta.added(workingCopy, 65536);
            this.addDelta(delta);
        }
        this.resultElements = new IModelElement[]{workingCopy};
    }

    protected SourceModule getWorkingCopy() {
        return (SourceModule)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

