/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.IAccessRule;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRule;

public class BuildpathAccessRule
extends AccessRule
implements IAccessRule {
    public BuildpathAccessRule(IPath pattern, int kind) {
        this(pattern.toString().toCharArray(), BuildpathAccessRule.toProblemId(kind));
    }

    public BuildpathAccessRule(char[] pattern, int problemId) {
        super(pattern, problemId);
    }

    private static int toProblemId(int kind) {
        boolean ignoreIfBetter = (kind & 0x100) != 0;
        switch (kind & 0xFFFFFEFF) {
            case 1: {
                return ignoreIfBetter ? 0x3000133 : 0x1000133;
            }
            case 2: {
                return ignoreIfBetter ? 50331928 : 0x1000118;
            }
        }
        return ignoreIfBetter ? 0x2000000 : 0;
    }

    @Override
    public IPath getPattern() {
        return new Path(new String(this.pattern));
    }

    @Override
    public int getKind() {
        switch (this.getProblemId()) {
            case 0x1000133: {
                return 1;
            }
            case 0x1000118: {
                return 2;
            }
        }
        return 0;
    }
}

