/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.IJSInitializer;
import org.eclipse.dltk.mod.internal.core.Member;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.util.Util;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.eclipse.core.IJSType;

public class JSInitializer
extends Member
implements IJSInitializer {
    public static final char JEM_INITIALIZER = '|';

    public JSInitializer(ModelElement parent, int count) {
        super(parent);
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.occurrenceCount = count;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JSInitializer)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 11;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.occurrenceCount);
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '|';
    }

    @Override
    public ISourceRange getNameRange() {
        return null;
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        SourceModule cu;
        if (checkOwner && ((cu = (SourceModule)this.getAncestor(5)) == null || cu.isPrimary())) {
            return this;
        }
        IModelElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IJSType)primaryParent).getInitializer(this.occurrenceCount);
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.occurrenceCount);
    }

    @Override
    public void printNode(CorePrinter output) {
    }

    public String readableName() {
        return ((ModelElement)((Object)this.getDeclaringType())).getElementName();
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws ModelException {
        throw new ModelException(new ModelStatus(967, this));
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append("> (not open)");
        } else if (info == NO_INFO) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append(">");
        } else {
            try {
                buffer.append("<");
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                buffer.append("initializer #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            }
            catch (ModelException modelException) {
                buffer.append("<ModelException in toString of " + this.getElementName());
            }
        }
    }
}

