/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceModuleFactory;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.CreateSourceModuleOperation;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptFolderInfo;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class ScriptFolder
extends Openable
implements IScriptFolder {
    protected IPath path;

    protected ScriptFolder(ProjectFragment parent, IPath path) {
        super(parent);
        this.path = path;
    }

    @Override
    protected Object createElementInfo() {
        return new ScriptFolderInfo();
    }

    @Override
    public int getElementType() {
        return 4;
    }

    @Override
    public IPath getPath() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return new Path(String.valueOf(root.getPath().toPortableString()) + "!").append(this.path);
        }
        return root.getPath().append(this.path);
    }

    @Override
    public IResource getResource() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getResource();
        }
        if (this.path.segmentCount() == 0) {
            return root.getResource();
        }
        IContainer container = (IContainer)root.getResource();
        if (container != null) {
            return container.getFolder(this.path);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptFolder)) {
            return false;
        }
        ScriptFolder other = (ScriptFolder)o;
        return this.path.equals((Object)other.path) && this.parent.equals(other.parent);
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.path.hashCode());
    }

    public int getKind() throws ModelException {
        return this.getProjectFragment().getKind();
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        int kind = this.getKind();
        if (kind == 1 && Util.isExcluded(this)) {
            throw this.newNotPresentException();
        }
        HashSet<ISourceModule> vChildren = new HashSet<ISourceModule>();
        try {
            ProjectFragment root = this.getProjectFragment();
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            IResource[] members = ((IContainer)underlyingResource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource child = members[i];
                if (child.getType() != 2 && !Util.isExcluded(child, inclusionPatterns, exclusionPatterns) && kind == 1 && Util.isValidSourceModule((IModelElement)this, child)) {
                    ISourceModule childElement = this.getSourceModule(child.getName());
                    vChildren.add(childElement);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        if (kind == 1) {
            ISourceModule[] primarySourceModules = this.getSourceModules(DefaultWorkingCopyOwner.PRIMARY);
            int i = 0;
            int length = primarySourceModules.length;
            while (i < length) {
                ISourceModule primary = primarySourceModules[i];
                vChildren.add(primary);
                ++i;
            }
        }
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public ISourceModule[] getSourceModules(WorkingCopyOwner owner) {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, false);
        if (workingCopies == null) {
            return ModelManager.NO_WORKING_COPY;
        }
        int length = workingCopies.length;
        ISourceModule[] result = new ISourceModule[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            ISourceModule wc = workingCopies[i];
            IResource res = wc.getResource();
            boolean valid = res != null ? Util.isValidSourceModule((IModelElement)this, res) : Util.isValidSourceModule((IModelElement)this, wc.getPath());
            if (this.equals(wc.getParent()) && !Util.isExcluded(wc) && valid) {
                result[index++] = wc;
            }
            ++i;
        }
        if (index != length) {
            ISourceModule[] iSourceModuleArray = result;
            result = new ISourceModule[index];
            System.arraycopy(iSourceModuleArray, 0, result, 0, index);
        }
        return result;
    }

    @Override
    public ISourceModule getSourceModule(String name) {
        return this.createSourceModule(name, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public ISourceModule createSourceModule(String cuName, String contents, boolean force, IProgressMonitor monitor) throws ModelException {
        CreateSourceModuleOperation op = new CreateSourceModuleOperation(this, cuName, contents, force);
        op.runOperation(monitor);
        return this.createSourceModule(cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public final ProjectFragment getProjectFragment() {
        return (ProjectFragment)this.getParent();
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            buffer.append("<default>");
        } else {
            buffer.append(elementName);
        }
    }

    @Override
    public String getElementName() {
        String name = "";
        if (this.path.segmentCount() == 0) {
            return "";
        }
        name = this.path.segment(0);
        int i = 1;
        while (i < this.path.segmentCount()) {
            name = String.valueOf(name) + '.' + this.path.segment(i);
            ++i;
        }
        return name;
    }

    @Override
    public boolean isRootFolder() {
        return this.path.segmentCount() == 0;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Script folder:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        if (this.isRootFolder()) {
            return ModelElementInfo.NO_NON_SCRIPT_RESOURCES;
        }
        return ((ScriptFolderInfo)this.getElementInfo()).getForeignResources(this.getResource(), this.getProjectFragment());
    }

    @Override
    public boolean hasSubfolders() throws ModelException {
        IModelElement[] packages = ((IProjectFragment)this.getParent()).getChildren();
        int namesLength = this.path.segmentCount();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            block4: {
                IPath otherNames = ((ScriptFolder)packages[i]).path;
                if (otherNames.segmentCount() > namesLength) {
                    int j = 0;
                    while (j < namesLength) {
                        if (this.path.segment(j).equals(otherNames.segment(j))) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)((Object)this.getSourceModule(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '<';
    }

    @Override
    public boolean containsScriptResources() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (!(elementInfo instanceof ScriptFolderInfo)) {
            return false;
        }
        ScriptFolderInfo scriptElementInfo = (ScriptFolderInfo)elementInfo;
        return scriptElementInfo.containsScriptResources();
    }

    @Override
    public boolean hasChildren() throws ModelException {
        return this.getChildren().length > 0;
    }

    @Override
    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        IModelElement[] siblings = null;
        if (sibling != null) {
            siblings = new IModelElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().copy(elements, containers, siblings, renamings, replace, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        IModelElement[] elements = new IModelElement[]{this};
        this.getModel().delete(elements, force, monitor);
    }

    @Override
    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        IModelElement[] siblings = null;
        if (sibling != null) {
            siblings = new IModelElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().move(elements, containers, siblings, renamings, replace, monitor);
    }

    @Override
    public void rename(String newName, boolean force, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getModel().rename(elements, dests, renamings, force, monitor);
    }

    public IPath getRelativePath() {
        return this.path;
    }

    public ISourceModule createSourceModule(String name, WorkingCopyOwner owner) {
        ISourceModuleFactory factory = this.getSourceModuleFactory(name);
        ISourceModule sourceModule = factory != null ? factory.createSourceModule(this, name, owner) : new SourceModule(this, name, owner);
        return sourceModule;
    }

    protected ISourceModuleFactory getSourceModuleFactory(String moduleName) {
        IPath modulePath = this.path.append(moduleName);
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.findToolkit(modulePath);
        ISourceModuleFactory factory = null;
        if (toolkit != null) {
            String natureId = toolkit.getNatureId();
            factory = DLTKLanguageManager.getSourceModuleFactory(natureId);
        }
        return factory;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        IResource rootResource = this.parent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        if (rootResource.getType() == 2 || rootResource.getType() == 4) {
            IContainer folder = (IContainer)rootResource;
            String[] segs = this.path.segments();
            int i = 0;
            while (i < segs.length) {
                IResource child = folder.findMember(segs[i]);
                if (child == null || child.getType() != 2) {
                    throw this.newNotPresentException();
                }
                folder = (IFolder)child;
                ++i;
            }
            return folder;
        }
        return rootResource;
    }
}

