/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.mixin;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.search.index.Index;
import org.eclipse.dltk.mod.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.mod.internal.core.mixin.MixinIndexRequest;

class MixinSourceModulesRequest
extends MixinIndexRequest {
    private final IScriptProject project;
    private final IDLTKLanguageToolkit toolkit;
    private final Set modules;

    public MixinSourceModulesRequest(IScriptProject project, IDLTKLanguageToolkit toolkit, Set modules) {
        this.project = project;
        this.toolkit = toolkit;
        this.modules = modules;
    }

    @Override
    protected String getName() {
        return this.project.getElementName();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws CoreException, IOException {
        IPath containerPath;
        Index index = this.getProjectMixinIndex(this.project);
        List changes = this.checkChanges(index, this.modules, containerPath = this.project.getPath(), EnvironmentManager.getEnvironment(this.project));
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            block19: {
                Iterator i;
                block18: {
                    i = changes.iterator();
                    if (!true) break block18;
                    if (this.isCancelled) return;
                    if (!i.hasNext()) break block19;
                }
                do {
                    Object change;
                    if ((change = i.next()) instanceof String) {
                        index.remove((String)change);
                    } else {
                        this.indexSourceModule(index, this.toolkit, (ISourceModule)change, containerPath);
                    }
                    if (this.isCancelled) return;
                } while (i.hasNext());
            }
            return;
        }
        finally {
            block17: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }
}

