/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.mod.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class BuildpathModifierOperation
extends BuildpathModifier
implements IRunnableWithProgress {
    protected IBuildpathInformationProvider fInformationProvider;
    protected CoreException fException;
    private int fType;
    private String fName;

    public BuildpathModifierOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider, String name, int type) {
        super(listener);
        this.fInformationProvider = informationProvider;
        this.fException = null;
        this.fName = name;
        this.fType = type;
    }

    protected void handleResult(List result, IProgressMonitor monitor) throws InvocationTargetException {
        if (monitor != null && this.fException != null) {
            throw new InvocationTargetException(this.fException);
        }
        this.fInformationProvider.handleResult(result, this.fException, this.fType);
        this.fException = null;
    }

    public abstract void run(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public String getId() {
        return Integer.toString(this.fType);
    }

    public abstract boolean isValid(List var1, int[] var2) throws ModelException;

    public abstract String getDescription(int var1);

    public String getName() {
        return this.fName;
    }

    public List getSelectedElements() {
        return this.fInformationProvider.getSelection().toList();
    }

    public int getTypeId() {
        return this.fType;
    }

    public boolean isValid() throws ModelException {
        List selectedElements = this.getSelectedElements();
        int[] types = new int[selectedElements.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = DialogPackageExplorerActionGroup.getType(selectedElements.get(i), this.fInformationProvider.getScriptProject());
            ++i;
        }
        return this.isValid(selectedElements, types);
    }
}

