/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.mod.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;

public class ResetOperation
extends BuildpathModifierOperation {
    public ResetOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip, 7);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List selection = this.getSelectedElements();
            IScriptProject project = this.fInformationProvider.getScriptProject();
            result = this.reset(selection, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        IScriptProject project = this.fInformationProvider.getScriptProject();
        boolean hasResetableFragmentRoot = false;
        boolean hasOutputFolder = false;
        boolean hasResetableProject = false;
        int i = 0;
        while (i < elements.size()) {
            switch (types[i]) {
                case 1: {
                    hasResetableProject = this.isValidProject(project);
                    break;
                }
                case 2: {
                    break;
                }
                case 14: {
                    hasResetableFragmentRoot = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return hasResetableFragmentRoot || hasOutputFolder || hasResetableProject;
    }

    private boolean isValidProject(IScriptProject project) throws ModelException {
        IBuildpathEntry entry;
        return project.isOnBuildpath((IModelElement)project) && ((entry = BuildpathModifier.getBuildpathEntryFor(project.getPath(), project, 3)).getInclusionPatterns().length != 0 || entry.getExclusionPatterns().length != 0);
    }

    @Override
    public String getDescription(int type) {
        if (type == 14 || type == 31) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_ResetFilters;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Reset;
    }
}

