/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CreateFileChange
extends DLTKChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;

    public CreateFileChange(IPath path, String source, String encoding) {
        this(path, source, encoding, -1L);
    }

    public CreateFileChange(IPath path, String source, String encoding, long stampToRestore) {
        Assert.isNotNull((Object)path, (String)"path");
        Assert.isNotNull((Object)source, (String)"source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        if (this.fChangeName == null) {
            return Messages.format(NLSChangesMessages.createFile_Create_file, this.fPath.toOSString());
        }
        return this.fChangeName;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected String getSource() {
        return this.fSource;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_unknownLocation, file.getFullPath().toString()));
            return result;
        }
        IFileInfo jFile = EFS.getStore((URI)location).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_exists, file.getFullPath().toString()));
            return result;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        InputStream is = null;
        try {
            pm.beginTask(NLSChangesMessages.createFile_creating_resource, 3);
            this.initializeEncoding();
            IFile file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
            try {
                is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                file.create(is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (this.fStampToRestore != -1L) {
                    file.revertModificationStamp(this.fStampToRestore);
                }
                if (this.fExplicitEncoding) {
                    file.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
                DeleteFileChange deleteFileChange = new DeleteFileChange(file);
                return deleteFileChange;
            }
            catch (UnsupportedEncodingException e) {
                throw new ModelException((Throwable)e, 985);
            }
        }
        finally {
            try {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new ModelException((Throwable)ioe, 985);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        pm.beginTask("", 1);
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            return iFile;
        }
        finally {
            pm.done();
        }
    }

    private void initializeEncoding() {
        block8: {
            if (this.fEncoding == null) {
                this.fExplicitEncoding = false;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
                if (file != null) {
                    try {
                        if (file.exists()) {
                            this.fEncoding = file.getCharset(false);
                            if (this.fEncoding == null) {
                                this.fEncoding = file.getCharset(true);
                            } else {
                                this.fExplicitEncoding = true;
                            }
                            break block8;
                        }
                        this.fEncoding = file.getCharset(true);
                    }
                    catch (CoreException coreException) {
                        this.fEncoding = ResourcesPlugin.getEncoding();
                        this.fExplicitEncoding = true;
                    }
                } else {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

