/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.text;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class CompositeReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IReconcilingStrategy[] fStrategies;

    public void setReconcilingStrategies(IReconcilingStrategy[] strategies) {
        this.fStrategies = strategies;
    }

    public IReconcilingStrategy[] getReconcilingStrategies() {
        return this.fStrategies;
    }

    public void setDocument(IDocument document) {
        if (this.fStrategies == null) {
            return;
        }
        int i = 0;
        while (i < this.fStrategies.length) {
            this.fStrategies[i].setDocument(document);
            ++i;
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.fStrategies == null) {
            return;
        }
        int i = 0;
        while (i < this.fStrategies.length) {
            this.fStrategies[i].reconcile(dirtyRegion, subRegion);
            ++i;
        }
    }

    public void reconcile(IRegion partition) {
        if (this.fStrategies == null) {
            return;
        }
        int i = 0;
        while (i < this.fStrategies.length) {
            this.fStrategies[i].reconcile(partition);
            ++i;
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (this.fStrategies == null) {
            return;
        }
        int i = 0;
        while (i < this.fStrategies.length) {
            if (this.fStrategies[i] instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)this.fStrategies[i];
                extension.setProgressMonitor(monitor);
            }
            ++i;
        }
    }

    public void initialReconcile() {
        if (this.fStrategies == null) {
            return;
        }
        int i = 0;
        while (i < this.fStrategies.length) {
            if (this.fStrategies[i] instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)this.fStrategies[i];
                extension.initialReconcile();
            }
            ++i;
        }
    }
}

