/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.text;

import org.eclipse.dltk.mod.internal.ui.text.CompositeReconcilingStrategy;
import org.eclipse.dltk.mod.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.mod.internal.ui.text.ScriptReconcilingStrategy;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private ScriptReconcilingStrategy fScriptStrategy;

    public ScriptCompositeReconcilingStrategy(ITextEditor editor, String documentPartitioning) {
        this.fEditor = editor;
        this.fScriptStrategy = new ScriptReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fScriptStrategy});
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel m;
        if (this.fEditor == null) {
            return null;
        }
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)this.fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    @Override
    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(dirtyRegion, subRegion);
        }
    }

    @Override
    public void reconcile(IRegion partition) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(partition);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(partition);
        }
    }

    @Override
    public void initialReconcile() {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.initialReconcile();
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.initialReconcile();
        }
    }

    public void notifyListeners(boolean notify) {
        this.fScriptStrategy.notifyListeners(notify);
    }

    public void aboutToBeReconciled() {
        this.fScriptStrategy.aboutToBeReconciled();
    }
}

