/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.mod.internal.ui.filters.LibraryFilter;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ModelElementSorter;
import org.eclipse.dltk.mod.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public abstract class DialogPackageExplorer
implements IMenuListener,
ISelectionChangedListener {
    private TreeViewer fPackageViewer;
    private Menu fContextMenu;
    private DialogPackageExplorerActionGroup fActionGroup = null;
    private IStructuredSelection fCurrentSelection = new StructuredSelection();
    private IScriptProject fCurrJProject = null;

    public Control createControl(Composite parent) {
        this.fPackageViewer = new TreeViewer(parent, 2);
        if (DLTKCore.DEBUG) {
            System.err.println("Add comparer");
        }
        this.fPackageViewer.addFilter((ViewerFilter)new PackageFilter());
        this.fPackageViewer.setSorter((ViewerSorter)new ExtendedModelElementSorter());
        this.fPackageViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (DialogPackageExplorer.this.fPackageViewer.isExpandable(element)) {
                    DialogPackageExplorer.this.fPackageViewer.setExpandedState(element, !DialogPackageExplorer.this.fPackageViewer.getExpandedState(element));
                }
            }
        });
        this.fPackageViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fPackageViewer.getTree());
        this.fPackageViewer.getTree().setMenu(this.fContextMenu);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialogPackageExplorer.this.fContextMenu.dispose();
            }
        });
        return this.fPackageViewer.getControl();
    }

    public void setActionGroup(final DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
        this.fPackageViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (actionGroup != null) {
                    actionGroup.dispose();
                }
            }
        });
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fActionGroup == null) {
            return;
        }
        DLTKUIPlugin.createStandardGroups(manager);
        this.fActionGroup.fillContextMenu(manager);
    }

    public void setContentProvider() {
        PackageContentProvider contentProvider = new PackageContentProvider();
        PackageLabelProvider labelProvider = new PackageLabelProvider(564186904002603L, 3, this.getPreferenceStore());
        this.fPackageViewer.setContentProvider((IContentProvider)contentProvider);
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingModelLabelProvider(labelProvider, false));
    }

    protected abstract IPreferenceStore getPreferenceStore();

    public void setInput(IScriptProject project) {
        this.fCurrJProject = project;
        this.fPackageViewer.setInput(new Object());
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.fPackageViewer.setSelection((ISelection)selection);
        this.fPackageViewer.expandToLevel(2);
        this.fCurrentSelection = selection;
        try {
            if (this.fActionGroup != null) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext((ISelection)this.fCurrentSelection, this.fCurrJProject));
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
    }

    public void refresh() {
        this.fPackageViewer.refresh(true);
    }

    public void setSelection(List elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        this.fPackageViewer.refresh();
        StructuredSelection selection = new StructuredSelection(elements);
        this.fPackageViewer.setSelection((ISelection)selection, true);
        this.fPackageViewer.getTree().setFocus();
        if (elements.size() == 1 && elements.get(0) instanceof IScriptProject) {
            this.fPackageViewer.expandToLevel(elements.get(0), 1);
        }
    }

    public IStructuredSelection getSelection() {
        return this.fCurrentSelection;
    }

    public Control getViewerControl() {
        return this.fPackageViewer.getControl();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fCurrentSelection = (IStructuredSelection)event.getSelection();
        try {
            if (this.fActionGroup != null) {
                this.fActionGroup.setContext(new DialogPackageExplorerActionGroup.DialogExplorerActionContext((ISelection)this.fCurrentSelection, this.fCurrJProject));
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
    }

    private final class ExtendedModelElementSorter
    extends ModelElementSorter {
        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof BPListElementAttribute) {
                return -1;
            }
            if (e2 instanceof BPListElementAttribute) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class PackageContentProvider
    extends StandardModelElementContentProvider {
        @Override
        public Object[] getElements(Object element) {
            if (DialogPackageExplorer.this.fCurrJProject == null) {
                return new Object[0];
            }
            return new Object[]{DialogPackageExplorer.this.fCurrJProject};
        }
    }

    private final class PackageFilter
    extends LibraryFilter {
        private PackageFilter() {
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block4: {
                IFile file;
                if (!(element instanceof IFile) || !(file = (IFile)element).getName().equals(".buildpath") && !file.getName().equals(".project")) break block4;
                return false;
            }
            try {
                IBuildpathEntry cpe;
                if (element instanceof IProjectFragment && ((cpe = ((IProjectFragment)element).getRawBuildpathEntry()) == null || cpe.getEntryKind() == 5)) {
                    return false;
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            return true;
        }
    }

    private final class PackageLabelProvider
    extends AppearanceAwareLabelProvider {
        public PackageLabelProvider(long textFlags, int imageFlags, IPreferenceStore store) {
            super(textFlags, imageFlags, store);
        }

        @Override
        public String getText(Object element) {
            String text = super.getText(element);
            try {
                IResource resource;
                IProjectFragment root;
                IScriptProject project;
                IProjectFragment root2;
                if (element instanceof IProjectFragment && (root2 = (IProjectFragment)element).exists() && BuildpathModifier.filtersSet(root2)) {
                    IBuildpathEntry entry = root2.getRawBuildpathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if (element instanceof IScriptProject && (project = (IScriptProject)element).exists() && project.isOnBuildpath((IModelElement)project) && BuildpathModifier.filtersSet(root = project.findProjectFragment(project.getPath()))) {
                    IBuildpathEntry entry = root.getRawBuildpathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && BuildpathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_Excluded, text);
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            return text;
        }

        @Override
        public Color getForeground(Object element) {
            try {
                IResource resource;
                IProjectFragment root;
                IScriptProject project;
                IProjectFragment root2;
                if (element instanceof IProjectFragment && (root2 = (IProjectFragment)element).exists() && BuildpathModifier.filtersSet(root2)) {
                    return this.getBlueColor();
                }
                if (element instanceof IScriptProject && (project = (IScriptProject)element).exists() && project.isOnBuildpath((IModelElement)project) && (root = project.findProjectFragment(project.getPath())) != null && BuildpathModifier.filtersSet(root)) {
                    return this.getBlueColor();
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && BuildpathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return this.getBlueColor();
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            return null;
        }

        private Color getBlueColor() {
            return Display.getCurrent().getSystemColor(9);
        }

        @Override
        public Image getImage(Object element) {
            return super.getImage(element);
        }

        @Override
        public void dispose() {
            super.dispose();
        }

        protected ImageDescriptor getSourceModuleIcon(IModelElement element, int renderFlags) {
            if (DLTKCore.DEBUG) {
                System.err.println("Dialog package explorer label provider returns ghost for source modules...");
            }
            return DLTKPluginImages.DESC_OBJS_GHOST;
        }
    }
}

