/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.af.common.error;

import java.io.Serializable;

public class ErrorId
implements Serializable {
    public static final char SEPARATOR = '.';
    private String m_context;
    private String m_category;
    private String m_subcategory;
    private String m_name;
    private static final long serialVersionUID = -6541136898302759215L;

    public ErrorId(String errorID) {
        if (errorID == null) {
            throw new IllegalArgumentException("Error: null error ID supplied.");
        }
        String[] tokens = errorID.split("\\.");
        if (tokens.length < 3) {
            throw new IllegalArgumentException("Error: incomplete error ID supplied. Error ID must be of the form of 'category.subcategory.name'.");
        }
        if (tokens.length > 4) {
            throw new IllegalArgumentException("Error:  too many periods in error ID. Error ID must be of the form of 'category.subcategory.name' or 'context.category.subcategory.name'.");
        }
        int index = tokens.length - 1;
        this.m_name = tokens[index--];
        this.m_subcategory = tokens[index--];
        this.m_category = tokens[index--];
        this.m_context = index >= 0 ? tokens[index] : null;
    }

    public ErrorId(String category, String subcategory, String name) {
        this.m_context = null;
        this.setCategory(category);
        this.setSubCategory(subcategory);
        this.setName(name);
    }

    public ErrorId(String context, String category, String subcategory, String name) {
        if (context == null || context.length() == 0) {
            throw new IllegalArgumentException("context must not be null or empty");
        }
        this.m_context = context;
        this.setCategory(category);
        this.setSubCategory(subcategory);
        this.setName(name);
    }

    public void setCategory(String category) {
        if (category == null) {
            throw new NullPointerException("Error category must be supplied");
        }
        if (category.length() == 0) {
            throw new NullPointerException("Error category must be a non-empty String");
        }
        this.m_category = category;
    }

    public void setSubCategory(String subcategory) {
        if (subcategory == null) {
            throw new NullPointerException("Error sub-category must be supplied");
        }
        if (subcategory.length() == 0) {
            throw new NullPointerException("Error sub-category must be a non-empty String");
        }
        this.m_subcategory = subcategory;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Error name must be supplied");
        }
        if (name.length() == 0) {
            throw new NullPointerException("Error name must be a non-empty String");
        }
        this.m_name = name;
    }

    public String getContext() {
        return this.m_context;
    }

    public String getCategory() {
        return this.m_category;
    }

    public String getSubCategory() {
        return this.m_subcategory;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean equals(ErrorId id) {
        String context = id.getContext();
        String category = id.getCategory();
        String subcategory = id.getSubCategory();
        String name = id.getName();
        if (this.m_context != context) {
            if (this.m_context == null && context != null) {
                return false;
            }
            if (this.m_context != null && !this.m_context.equals(context)) {
                return false;
            }
        }
        if (this.m_category != category) {
            if (this.m_category == null || category == null) {
                return false;
            }
            if (!this.m_category.equals(category)) {
                return false;
            }
        }
        if (this.m_subcategory != subcategory) {
            if (this.m_subcategory == null || subcategory == null) {
                return false;
            }
            if (!this.m_subcategory.equals(subcategory)) {
                return false;
            }
        }
        if (this.m_name != name) {
            if (this.m_name == null || name == null) {
                return false;
            }
            if (!this.m_name.equals(name)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ErrorId) {
            return this.equals((ErrorId)object);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        if (this.m_context != null) {
            hash ^= this.m_context.hashCode();
        }
        hash ^= this.m_category.hashCode();
        hash ^= this.m_subcategory.hashCode();
        return hash ^= this.m_name.hashCode();
    }

    public String toString() {
        return this.getFullName();
    }

    public String getFullName() {
        StringBuilder rb = new StringBuilder();
        if (this.m_context != null) {
            rb.append(this.m_context).append('.');
        }
        rb.append(this.m_category).append('.');
        rb.append(this.m_subcategory).append('.');
        rb.append(this.m_name);
        return rb.toString();
    }
}

