/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.af.common.error;

import java.io.Serializable;
import org.eclipse.vjet.af.common.error.ErrorArgsInterface;
import org.eclipse.vjet.af.common.error.ErrorId;
import org.eclipse.vjet.af.common.error.ErrorSeverity;

public class ErrorObject
implements Serializable {
    ErrorId m_id;
    ErrorSeverity m_severity;
    ErrorArgsInterface m_parameters;
    ErrorArgsInterface m_correlations;
    private static final long serialVersionUID = -7180485712868396374L;

    public ErrorObject(ErrorId id, ErrorSeverity severity) {
        this.setId(id);
        this.setSeverity(severity);
        this.m_parameters = null;
        this.m_correlations = null;
    }

    public ErrorObject(ErrorId id, ErrorSeverity severity, ErrorArgsInterface parameters) {
        this.setId(id);
        this.setSeverity(severity);
        this.m_parameters = parameters;
        this.m_correlations = null;
    }

    public ErrorObject(ErrorId id, ErrorSeverity severity, ErrorArgsInterface parameters, ErrorArgsInterface correlations) {
        this.setId(id);
        this.setSeverity(severity);
        this.m_parameters = parameters;
        this.m_correlations = correlations;
    }

    public void setId(ErrorId id) {
        if (id == null) {
            throw new NullPointerException("The supplied Id must not be null");
        }
        this.m_id = id;
    }

    public ErrorId getId() {
        return this.m_id;
    }

    public void setSeverity(ErrorSeverity severity) {
        if (severity == null) {
            throw new NullPointerException("The supplied severity must not be null");
        }
        this.m_severity = severity;
    }

    public ErrorSeverity getSeverity() {
        return this.m_severity;
    }

    public void setParameters(ErrorArgsInterface parameters) {
        this.m_parameters = parameters;
    }

    public ErrorArgsInterface getParameters() {
        return this.m_parameters;
    }

    public void setCorrelations(ErrorArgsInterface correlations) {
        this.m_correlations = correlations;
    }

    public ErrorArgsInterface getCorrelations() {
        return this.m_correlations;
    }

    public boolean equals(ErrorObject thatErrorObject) {
        if (this.m_id != thatErrorObject.m_id) {
            if (this.m_id == null || thatErrorObject.m_id == null) {
                return false;
            }
            if (!this.m_id.equals(thatErrorObject.m_id)) {
                return false;
            }
        }
        if (this.m_severity != thatErrorObject.m_severity) {
            if (this.m_severity == null || thatErrorObject.m_severity == null) {
                return false;
            }
            if (!this.m_severity.equals((Object)thatErrorObject.m_severity)) {
                return false;
            }
        }
        if (this.m_parameters != thatErrorObject.m_parameters) {
            if (this.m_parameters == null || thatErrorObject.m_parameters == null) {
                return false;
            }
            if (!this.m_parameters.equals(thatErrorObject.m_parameters)) {
                return false;
            }
        }
        if (this.m_correlations != thatErrorObject.m_correlations) {
            if (this.m_correlations == null || thatErrorObject.m_correlations == null) {
                return false;
            }
            if (!this.m_correlations.equals(thatErrorObject.m_correlations)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ErrorObject) {
            return this.equals((ErrorObject)object);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        hash ^= this.m_id.hashCode();
        hash ^= this.m_severity.hashCode();
        if (this.m_parameters != null) {
            hash ^= this.m_parameters.hashCode();
        }
        if (this.m_correlations != null) {
            hash ^= this.m_correlations.hashCode();
        }
        return hash;
    }

    public boolean isInfo() {
        return this.m_severity.equals((Object)ErrorSeverity.INFO);
    }

    public boolean isWarning() {
        return this.m_severity.equals((Object)ErrorSeverity.WARNING);
    }

    public boolean isError() {
        return this.m_severity.equals((Object)ErrorSeverity.ERROR);
    }

    public boolean isFatal() {
        return this.m_severity.equals((Object)ErrorSeverity.FATAL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append("Id : ");
        sb.append(this.getId().toString());
        sb.append(", Severity : ");
        sb.append(this.getSeverity().toString());
        ErrorArgsInterface parameters = this.getParameters();
        sb.append(", Parameters : ");
        if (parameters == null) {
            sb.append("{}");
        } else {
            sb.append(parameters.toString());
        }
        ErrorArgsInterface correlations = this.getCorrelations();
        sb.append(", Correlations : ");
        if (correlations == null) {
            sb.append("{}");
        } else {
            sb.append(correlations.toString());
        }
        sb.append(" }");
        return sb.toString();
    }
}

