/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.kernel.stage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.kernel.stage.IStage;
import org.eclipse.vjet.kernel.stage.IStageProvider;

public class DefaultStageProvider<T>
implements IStageProvider<T> {
    private Map<T, IStage<T>> m_stages = new HashMap<T, IStage<T>>();

    @Override
    public DefaultStageProvider<T> add(IStage<T> stage) {
        if (stage == null) {
            throw new RuntimeException("stage is null");
        }
        if (stage.getId() == null) {
            throw new RuntimeException("stage id is null");
        }
        if (this.m_stages.containsKey(stage.getId())) {
            throw new RuntimeException("there is already stage registered with this id:" + stage.getId());
        }
        this.m_stages.put(stage.getId(), stage);
        return this;
    }

    @Override
    public IStage<T> get(T stageId) {
        if (stageId == null) {
            throw new RuntimeException("stageId is null");
        }
        return this.m_stages.get(stageId);
    }

    @Override
    public Map<T, IStage<T>> getAll() {
        return Collections.unmodifiableMap(this.m_stages);
    }

    public boolean remove(T stageId) {
        return this.m_stages.remove(stageId) != null;
    }

    public void clear() {
        this.m_stages.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StageIds: ");
        for (T id : this.m_stages.keySet()) {
            sb.append(id).append(", ");
        }
        return sb.toString();
    }
}

