/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

public class AvlTree {
    private AvlNode root = null;

    public void insert(Comparable x) {
        this.root = this.insert(x, this.root);
    }

    public void remove(Comparable x) {
        System.out.println("Sorry, remove unimplemented");
    }

    public Comparable findMin() {
        return this.elementAt(this.findMin(this.root));
    }

    public Comparable findMax() {
        return this.elementAt(this.findMax(this.root));
    }

    public Comparable find(Comparable x) {
        return this.elementAt(this.find(x, this.root));
    }

    public void makeEmpty() {
        this.root = null;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public void printTree() {
        if (this.isEmpty()) {
            System.out.println("Empty tree");
        } else {
            this.printTree(this.root, 0);
        }
    }

    private Comparable elementAt(AvlNode t) {
        return t == null ? null : t.element;
    }

    private AvlNode insert(Comparable x, AvlNode t) {
        if (t == null) {
            t = new AvlNode(x, null, null);
        } else if (x.compareTo(t.element) < 0) {
            t.left = this.insert(x, t.left);
            if (AvlTree.height(t.left) - AvlTree.height(t.right) == 2) {
                t = x.compareTo(t.left.element) < 0 ? AvlTree.rotateWithLeftChild(t) : AvlTree.doubleWithLeftChild(t);
            }
        } else if (x.compareTo(t.element) > 0) {
            t.right = this.insert(x, t.right);
            if (AvlTree.height(t.right) - AvlTree.height(t.left) == 2) {
                t = x.compareTo(t.right.element) > 0 ? AvlTree.rotateWithRightChild(t) : AvlTree.doubleWithRightChild(t);
            }
        }
        t.height = AvlTree.max(AvlTree.height(t.left), AvlTree.height(t.right)) + 1;
        return t;
    }

    /*
     * Unable to fully structure code
     */
    private AvlNode findMin(AvlNode t) {
        if (t != null) ** GOTO lbl4
        return t;
lbl-1000:
        // 1 sources

        {
            t = t.left;
lbl4:
            // 2 sources

            ** while (t.left != null)
        }
lbl5:
        // 1 sources

        return t;
    }

    /*
     * Unable to fully structure code
     */
    private AvlNode findMax(AvlNode t) {
        if (t != null) ** GOTO lbl4
        return t;
lbl-1000:
        // 1 sources

        {
            t = t.right;
lbl4:
            // 2 sources

            ** while (t.right != null)
        }
lbl5:
        // 1 sources

        return t;
    }

    private AvlNode find(Comparable x, AvlNode t) {
        while (t != null) {
            if (x.compareTo(t.element) < 0) {
                t = t.left;
                continue;
            }
            if (x.compareTo(t.element) > 0) {
                t = t.right;
                continue;
            }
            return t;
        }
        return null;
    }

    private void printTree(AvlNode t, int indentLevel) {
        if (t != null) {
            this.printTree(t.left, indentLevel + 1);
            int i = 0;
            while (i < indentLevel) {
                System.out.print(" ");
                ++i;
            }
            System.out.println(t.element);
            this.printTree(t.right, indentLevel + 1);
        }
    }

    private static int height(AvlNode t) {
        return t == null ? -1 : t.height;
    }

    private static int max(int lhs, int rhs) {
        return lhs > rhs ? lhs : rhs;
    }

    private static AvlNode rotateWithLeftChild(AvlNode k2) {
        AvlNode k1 = k2.left;
        k2.left = k1.right;
        k1.right = k2;
        k2.height = AvlTree.max(AvlTree.height(k2.left), AvlTree.height(k2.right)) + 1;
        k1.height = AvlTree.max(AvlTree.height(k1.left), k2.height) + 1;
        return k1;
    }

    private static AvlNode rotateWithRightChild(AvlNode k1) {
        AvlNode k2 = k1.right;
        k1.right = k2.left;
        k2.left = k1;
        k1.height = AvlTree.max(AvlTree.height(k1.left), AvlTree.height(k1.right)) + 1;
        k2.height = AvlTree.max(AvlTree.height(k2.right), k1.height) + 1;
        return k2;
    }

    private static AvlNode doubleWithLeftChild(AvlNode k3) {
        k3.left = AvlTree.rotateWithRightChild(k3.left);
        return AvlTree.rotateWithLeftChild(k3);
    }

    private static AvlNode doubleWithRightChild(AvlNode k1) {
        k1.right = AvlTree.rotateWithLeftChild(k1.right);
        return AvlTree.rotateWithRightChild(k1);
    }

    public AvlNode getRoot() {
        return this.root;
    }

    public static void main(String[] args) {
        AvlTree t = new AvlTree();
        System.out.println("Checking... (no more output means success)");
        int i = 1;
        while (i < 4000) {
            t.insert(new Integer(i));
            i += 37;
        }
        t.find(new Integer(25));
        t.printTree();
        if ((Integer)t.findMin() != 1 || (Integer)t.findMax() != 3999) {
            System.out.println("FindMin or FindMax error!");
        }
        i = 1;
        while (i < 4000) {
            if ((Integer)t.find(new Integer(i)) != i) {
                System.out.println("Find error1!");
            }
            i += 37;
        }
    }

    class AvlNode {
        Comparable element;
        AvlNode left;
        AvlNode right;
        int height;
        Object userData;

        AvlNode(Comparable theElement) {
            this(theElement, null, null);
        }

        AvlNode(Comparable theElement, AvlNode lt, AvlNode rt) {
            this.element = theElement;
            this.left = lt;
            this.right = rt;
            this.height = 0;
        }
    }
}

