/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FileUtils {
    public static void writeFile(String fileName, String text, String characterEncoding) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        byte[] buf = text.getBytes(characterEncoding);
        FileOutputStream fos = new FileOutputStream(fileName);
        int numWritten = 0;
        fos.write(buf, numWritten, buf.length);
        fos.close();
    }

    public static String readFile(String fileName, String characterEncoding) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        int numRead;
        StringBuilder sb = new StringBuilder(75000);
        char[] buf = new char[4096];
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, characterEncoding);
        do {
            if ((numRead = isr.read(buf, 0, buf.length)) <= 0) continue;
            sb.append(buf, 0, numRead);
        } while (numRead >= 0);
        isr.close();
        fis.close();
        return sb.toString();
    }

    public static void copyFile(String sourceFile, String destinationFile) throws IOException {
        FileInputStream fis = new FileInputStream(sourceFile);
        FileOutputStream fos = new FileOutputStream(destinationFile);
        try {
            int numBytesRead;
            byte[] buffer = new byte[4096];
            do {
                if ((numBytesRead = fis.read(buffer)) <= 0) continue;
                fos.write(buffer, 0, numBytesRead);
            } while (numBytesRead >= 0);
        }
        finally {
            try {
                fos.flush();
            }
            finally {
                try {
                    fos.close();
                }
                finally {
                    fis.close();
                }
            }
        }
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        String text = FileUtils.readStream(inputStream);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String line = tokenizer.nextToken();
            list.add(line);
        }
        return list;
    }

    public static String readStream(InputStream inputStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(inputStream);
        try {
            String string = FileUtils.readStream(isr);
            return string;
        }
        finally {
            isr.close();
        }
    }

    public static String readStream(InputStreamReader isr) throws IOException {
        int numRead;
        StringBuffer sb = new StringBuffer(75000);
        char[] buf = new char[4096];
        do {
            if ((numRead = isr.read(buf, 0, buf.length)) <= 0) continue;
            sb.append(buf, 0, numRead);
        } while (numRead >= 0);
        String result = sb.toString();
        return result;
    }

    public static String getResourceAsString(String resourceName) throws IOException {
        return FileUtils.getResourceAsString(CallerIntrospector.getCaller(), resourceName);
    }

    public static String getResourceString(String resourceName) {
        return FileUtils.getResourceString(CallerIntrospector.getCaller(), resourceName);
    }

    public static String getResourceString(Class<?> clz, String resourceName) {
        try {
            return FileUtils.getResourceAsString(clz, resourceName);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getResourceAsString(Class<?> clz, String resourceName) throws IOException {
        int bytesRead;
        InputStream is = clz.getResourceAsStream(resourceName);
        byte[] bytes = new byte[4096];
        StringBuilder buffer = new StringBuilder();
        do {
            bytesRead = is.read(bytes);
            String thisChunk = new String(bytes, 0, bytesRead);
            buffer.append(thisChunk);
        } while (bytesRead >= 4096);
        return buffer.toString();
    }

    public static boolean isDirectoryWithFiles(String directory) {
        String[] files;
        if (directory == null || directory.trim().length() == 0) {
            return false;
        }
        File dir = new File(directory);
        return dir.isDirectory() && (files = dir.list()) != null && files.length > 0;
    }

    private static final class CallerIntrospector
    extends SecurityManager {
        static CallerIntrospector instance = new CallerIntrospector();

        private CallerIntrospector() {
        }

        static Class<?> getCaller() {
            return instance.getClassContext()[2];
        }
    }
}

