/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common;

import java.io.Serializable;
import org.eclipse.vjet.dsf.common.enums.BaseEnum;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public abstract class Id
extends BaseEnum
implements Serializable,
Cloneable {
    private static long s_sequence = 0L;
    private static int s_enumSequence = 0;

    public Id() {
        this(Id.nextDefaultName());
    }

    public Id(String name) {
        this(Id.getNextEnumSequence(), name, false);
    }

    public Id(int enumId, String name) {
        this(enumId, name, true);
    }

    public Id(int enumId, String name, boolean register) {
        super(enumId, name, register);
        if (name == null) {
            throw new DsfRuntimeException("Id must not be null");
        }
        if (name.trim().length() == 0) {
            throw new DsfRuntimeException("Id must not be empty or spaces");
        }
    }

    public static synchronized long getNextSequence() {
        return s_sequence++;
    }

    public static synchronized int getNextEnumSequence() {
        if (s_enumSequence == Integer.MAX_VALUE) {
            s_enumSequence = 0;
        }
        return s_enumSequence++;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Id)) {
            return false;
        }
        Id otherId = (Id)other;
        return this.getValue() == otherId.getValue() && this.getName().equals(otherId.getName());
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new DsfRuntimeException("Unexepected failure during clone");
        }
    }

    @Override
    public String toString() {
        return "(" + super.getId() + "," + super.getName() + ")";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected static synchronized String nextDefaultName() {
        return "Id" + Id.getNextSequence();
    }
}

