/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.config.FilterKey;
import org.eclipse.vjet.dsf.common.trace.config.HandlerKey;
import org.eclipse.vjet.dsf.common.trace.config.ListenerKey;

public final class ListenerConfig {
    private ListenerKey m_listenerKey;
    private List<FilterKey> m_filterKeys = new ArrayList<FilterKey>(1);
    private List<HandlerKey> m_handlerKeys = new ArrayList<HandlerKey>(1);

    public ListenerConfig(ListenerKey listenerKey) {
        if (listenerKey == null) {
            DsfExceptionHelper.chuck("listenerKey is null");
        }
        this.m_listenerKey = listenerKey;
    }

    public ListenerKey getListenerKey() {
        return this.m_listenerKey;
    }

    public synchronized void addFilter(FilterKey filterKey) {
        if (filterKey == null || this.m_filterKeys.contains(filterKey)) {
            return;
        }
        this.m_filterKeys.add(filterKey);
    }

    public synchronized boolean removeFilter(FilterKey filterKey) {
        return this.m_filterKeys.remove(filterKey);
    }

    public synchronized void removeAllFilters() {
        this.m_filterKeys.clear();
    }

    public synchronized List<FilterKey> getFilters() {
        return Collections.unmodifiableList(this.m_filterKeys);
    }

    public synchronized void addHandler(HandlerKey handlerKey) {
        if (handlerKey == null || this.m_handlerKeys.contains(handlerKey)) {
            return;
        }
        this.m_handlerKeys.add(handlerKey);
    }

    public synchronized boolean removeHandler(HandlerKey handlerKey) {
        return this.m_handlerKeys.remove(handlerKey);
    }

    public synchronized void removeAllHandlers() {
        this.m_handlerKeys.clear();
    }

    public synchronized List<HandlerKey> getHandlers() {
        return Collections.unmodifiableList(this.m_handlerKeys);
    }
}

