/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.handler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.eclipse.vjet.dsf.logger.EbayLogFileHandler;

public class TraceFileHandler
extends StreamHandler {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private File[] files;

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    private void configure(IConfigWrapper config) {
        ConfigHelper cfg = new ConfigHelper(config);
        String cname = EbayLogFileHandler.class.getName();
        this.pattern = cfg.getStringProperty(String.valueOf(cname) + ".pattern", "vjet.log");
        this.limit = cfg.getIntProperty(String.valueOf(cname) + ".limit", 0);
        if (this.limit < 0) {
            this.limit = 0;
        }
        this.count = cfg.getIntProperty(String.valueOf(cname) + ".count", 1);
        if (this.count <= 0) {
            this.count = 1;
        }
        this.append = cfg.getBooleanProperty(String.valueOf(cname) + ".append", false);
        this.setLevel(cfg.getLevelProperty(String.valueOf(cname) + ".level", Level.ALL));
        this.setFilter(cfg.getFilterProperty(String.valueOf(cname) + ".filter", null));
        try {
            this.setEncoding(cfg.getStringProperty(String.valueOf(cname) + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {}
        }
    }

    public TraceFileHandler(Properties props) throws IOException {
        this.configure(new PropertiesConfigWrapper(props));
        this.openFiles();
    }

    public TraceFileHandler() throws IOException, SecurityException {
        this.openFiles();
    }

    public TraceFileHandler(String pattern) throws IOException, SecurityException {
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.openFiles();
    }

    public TraceFileHandler(String pattern, boolean append) throws IOException, SecurityException {
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.append = append;
        this.openFiles();
    }

    public TraceFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.openFiles();
    }

    public TraceFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.openFiles();
    }

    private void openFiles() throws IOException {
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        int unique = 0;
        this.files = new File[this.count];
        int i = 0;
        while (i < this.count) {
            this.files[i] = this.generate(this.pattern, i, unique);
            ++i;
        }
        if (this.append) {
            this.open(this.files[0], true);
        } else {
            this.rotate();
        }
        Exception ex = em.lastException;
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new IOException("Exception: " + ex);
        }
        this.setErrorManager(new ErrorManager());
    }

    private File generate(String pattern, int generation, int unique) {
        File file = null;
        String word = "";
        int ix = 0;
        String logDir = System.getProperty("com.ebay.log.dir");
        if (logDir != null) {
            file = new File(logDir);
        }
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '.') {
                if (generation > 0) {
                    word = String.valueOf(word) + "_" + generation + ch;
                    continue;
                }
            } else if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = String.valueOf(word) + generation;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = String.valueOf(word) + unique;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = String.valueOf(word) + "%";
                    ++ix;
                    continue;
                }
            }
            word = String.valueOf(word) + ch;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        int i = this.count - 2;
        while (i >= 0) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (f1.exists() && f1.length() > 0L) {
                if (f2.exists()) {
                    f2.delete();
                }
                if (!f1.renameTo(f2)) {
                    System.err.println("Error renaming file " + f1.getName() + " to " + f2.getName());
                }
            }
            --i;
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                TraceFileHandler.this.rotate();
                return null;
            }
        });
        super.publish(record);
        this.flush();
    }

    @Override
    public synchronized void close() throws SecurityException {
        super.close();
    }

    private static class ConfigHelper {
        private final IConfigWrapper m_cfg;

        public ConfigHelper(IConfigWrapper cfg) {
            this.m_cfg = cfg;
        }

        String getStringProperty(String name, String defaultValue) {
            String val = this.m_cfg.getProperty(name);
            if (val == null) {
                return defaultValue;
            }
            return val.trim();
        }

        int getIntProperty(String name, int defaultValue) {
            String val = this.m_cfg.getProperty(name);
            if (val == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(val.trim());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        boolean getBooleanProperty(String name, boolean defaultValue) {
            String val = this.m_cfg.getProperty(name);
            if (val == null) {
                return defaultValue;
            }
            if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
                return true;
            }
            if (val.equals("false") || val.equals("0")) {
                return false;
            }
            return defaultValue;
        }

        Filter getFilterProperty(String name, Filter defaultValue) {
            String val = this.m_cfg.getProperty(name);
            try {
                if (val != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                    return (Filter)clz.newInstance();
                }
            }
            catch (Exception exception) {}
            return defaultValue;
        }

        Formatter getFormatterProperty(String name, Formatter defaultValue) {
            String val = this.m_cfg.getProperty(name);
            try {
                if (val != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                    return (Formatter)clz.newInstance();
                }
            }
            catch (Exception exception) {}
            return defaultValue;
        }

        Level getLevelProperty(String name, Level defaultValue) {
            String val = this.m_cfg.getProperty(name);
            if (val == null) {
                return defaultValue;
            }
            try {
                return Level.parse(val.trim());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
    }

    static interface IConfigWrapper {
        public String getProperty(String var1);
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }

    private static class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static class PropertiesConfigWrapper
    implements IConfigWrapper {
        final Properties m_properties;

        public PropertiesConfigWrapper(Properties properties) {
            this.m_properties = properties;
        }

        @Override
        public String getProperty(String key) {
            return this.m_properties.getProperty(key);
        }
    }
}

