/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamException;

public class XmlStreamWriterDebugger
implements IXmlStreamWriter {
    private final IXmlStreamWriter m_xmlStreamWriter;

    public XmlStreamWriterDebugger(IXmlStreamWriter xmlStreamWriter) {
        this.m_xmlStreamWriter = xmlStreamWriter;
    }

    @Override
    public void flush() {
        this.m_xmlStreamWriter.flush();
        this.out("flush()");
    }

    @Override
    public void writeAttribute(char[] attributeName, String value) {
        this.m_xmlStreamWriter.writeAttribute(attributeName, value);
        this.out("writeAttribute(" + new String(attributeName) + ", " + value + ")");
    }

    @Override
    public void writeAttribute(String attributeName, String value) {
        this.m_xmlStreamWriter.writeAttribute(attributeName, value);
        this.out("writeAttribute(" + attributeName + ", " + value + ")");
    }

    @Override
    public void writeCData(String data) {
        this.m_xmlStreamWriter.writeCData(data);
        this.out("writeCData(" + data + ")");
    }

    @Override
    public void writeRaw(String data) throws XmlStreamException {
        this.m_xmlStreamWriter.writeRaw(data);
        this.out("writeRaw(" + data + ")");
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        this.m_xmlStreamWriter.writeCharacters(text, start, len);
        this.out("writeCharacters(" + new String(text, start, len) + ")");
    }

    @Override
    public void writeCharacters(String text) {
        this.m_xmlStreamWriter.writeCharacters(text);
        this.out("writeCharacters(" + text + ")");
    }

    @Override
    public void writeComment(String data) {
        this.m_xmlStreamWriter.writeComment(data);
        this.out("writeComment(" + data + ")");
    }

    @Override
    public void writeDtd(String dtd) throws XmlStreamException {
        this.m_xmlStreamWriter.writeDtd(dtd);
        this.out("writeDtd(" + dtd + ")");
    }

    @Override
    public void writeEmptyElement(String tagName) {
        this.m_xmlStreamWriter.writeEmptyElement(tagName);
        this.out("writeEmptyElement(" + tagName + ")");
    }

    @Override
    public void writeEndDocument() {
        this.m_xmlStreamWriter.writeEndDocument();
        this.out("writeEndDocument()");
    }

    @Override
    public void writeEndElement() {
        this.m_xmlStreamWriter.writeEndElement();
        this.out("writeEndElement()");
    }

    @Override
    public void writeStartDocument() {
        this.m_xmlStreamWriter.writeStartDocument();
        this.out("writeStartDocument()");
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.m_xmlStreamWriter.writeStartDocument(encoding, version);
        this.out("writeStartDocument(" + encoding + version + ")");
    }

    @Override
    public void writeStartDocument(String version) {
        this.m_xmlStreamWriter.writeStartDocument(version);
        this.out("writeStartDocument(" + version + ")");
    }

    @Override
    public void writeStartElement(char[] tagNameAsChars) {
        this.m_xmlStreamWriter.writeStartElement(tagNameAsChars);
        this.out("writeStartElement(" + new String(tagNameAsChars) + ")");
    }

    @Override
    public void writeStartElement(String tagName) {
        this.m_xmlStreamWriter.writeStartElement(tagName);
        this.out("writeStartElement(" + tagName + ")");
    }

    @Override
    public void writeRawCharacters(char[] text, int start, int len) {
        this.m_xmlStreamWriter.writeRawCharacters(text, start, len);
        this.out("writeRawCharacters(" + new String(text, start, len) + ")");
    }

    private void out(String message) {
        System.out.println(message);
    }
}

