/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json;

import java.text.ParseException;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.JsonTokener;

public class CookieConvertor {
    public static String escape(String string) {
        String s = string.trim();
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c < ' ' || c == '+' || c == '%' || c == '=' || c == ';') {
                sb.append('%');
                sb.append(Character.forDigit((char)(c >>> 4 & 0xF), 16));
                sb.append(Character.forDigit((char)(c & 0xF), 16));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonObject toJSONObject(String string) throws ParseException {
        JsonObject o = new JsonObject();
        JsonTokener x = new JsonTokener(string);
        o.put("name", x.nextTo('='));
        x.next('=');
        o.put("value", x.nextTo(';'));
        x.next();
        while (x.more()) {
            Object v;
            String n = JsonTokener.unescape(x.nextTo("=;"));
            if (x.next() != '=') {
                if (!n.equals("secure")) throw x.syntaxError("Missing '=' in cookie parameter.");
                v = Boolean.TRUE;
            } else {
                v = JsonTokener.unescape(x.nextTo(';'));
                x.next();
            }
            o.put(n, v);
        }
        return o;
    }

    public static String toString(JsonObject o) {
        StringBuffer sb = new StringBuffer();
        sb.append(CookieConvertor.escape(o.getString("name")));
        sb.append("=");
        sb.append(CookieConvertor.escape(o.getString("value")));
        if (o.has("expires")) {
            sb.append(";expires=");
            sb.append(o.getString("expires"));
        }
        if (o.has("domain")) {
            sb.append(";domain=");
            sb.append(CookieConvertor.escape(o.getString("domain")));
        }
        if (o.has("path")) {
            sb.append(";path=");
            sb.append(CookieConvertor.escape(o.getString("path")));
        }
        if (o.optBoolean("secure")) {
            sb.append(";secure");
        }
        return sb.toString();
    }
}

