/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.logger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.eclipse.vjet.dsf.common.exceptions.BaseException;
import org.eclipse.vjet.dsf.common.exceptions.BaseRuntimeException;
import org.eclipse.vjet.dsf.common.initialization.InitializationException;
import org.eclipse.vjet.dsf.logger.EbayLogFileHandler;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.LoggingContext;

public class Logger {
    public static final String DEFAULT_RESOURCE_NAME = "logging.properties";
    public static final String BATCH_RESOURCE_NAME = "batch-logging.properties";
    public static final String NULL_RESOURCE_NAME = "null-logging.properties";
    public static final String CONSOLE_LOGGING_NAME = "console-logging.properties";
    private static String s_resourceName = "logging.properties";
    private static final ConcurrentMap<String, Logger> s_loggerList = new ConcurrentHashMap<String, Logger>(25);
    private final java.util.logging.Logger m_logger;
    private static boolean s_initialized = false;

    public static synchronized void initLogProperties(String name) {
        if (name == null || s_resourceName.equals(name)) {
            return;
        }
        s_resourceName = name;
        if (s_initialized) {
            s_initialized = false;
            try {
                Logger.initConfig();
            }
            catch (Exception e) {
                throw new InitializationException(e);
            }
        }
    }

    public static Logger getInstance(Class<?> callingClass) {
        String subsystem = null;
        subsystem = callingClass != null ? (callingClass.getPackage() != null ? callingClass.getPackage().getName() : callingClass.getName()) : "";
        return Logger.getInstance(subsystem);
    }

    public static Logger getInstance(String subsystem) {
        Logger newLogger;
        Logger logger = (Logger)s_loggerList.get(subsystem);
        if (logger == null && (logger = s_loggerList.putIfAbsent(subsystem, newLogger = new Logger(subsystem))) == null) {
            logger = newLogger;
        }
        return logger;
    }

    private Logger(String subsystem) {
        try {
            Logger.initConfig();
        }
        catch (Exception e) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : init error - " + e.getMessage());
            e.printStackTrace();
        }
        this.m_logger = java.util.logging.Logger.getLogger(subsystem);
    }

    protected static synchronized void initConfig() throws IOException {
        if (s_initialized) {
            return;
        }
        s_initialized = true;
        LogManager manager = LogManager.getLogManager();
        String cname = System.getProperty("java.util.logging.config.class");
        String fname = System.getProperty("java.util.logging.config.file");
        if (cname != null || fname != null) {
            manager.readConfiguration();
            return;
        }
    }

    static synchronized void reinit(Properties props) throws IOException {
        s_initialized = true;
        ArrayList<String> ebayHandlerNames = new ArrayList<String>();
        InputStream is = Logger.filterProperties(props, ebayHandlerNames);
        try {
            Logger.initConfig(is, ebayHandlerNames);
        }
        finally {
            is.close();
        }
    }

    private static void initConfig(InputStream is, Collection<String> ebayHandlerNames) throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.readConfiguration(is);
        if (!ebayHandlerNames.isEmpty()) {
            java.util.logging.Logger root = manager.getLogger("");
            if (root == null) {
                throw new IOException("Unthinkable: Root logger is not available");
            }
            for (String handlerName : ebayHandlerNames) {
                try {
                    Handler handler = (Handler)Class.forName(handlerName).newInstance();
                    root.addHandler(handler);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static InputStream filterProperties(InputStream is, Collection<String> ebayHandlerNames) throws IOException {
        Properties props = new Properties();
        if (is != null) {
            props.load(is);
        }
        return Logger.filterProperties(props, ebayHandlerNames);
    }

    private static InputStream filterProperties(Properties props, Collection<String> ebayHandlerNames) throws IOException {
        Properties props2 = new Properties();
        String handlersStr = props2.getProperty("handlers");
        if (handlersStr != null && handlersStr.trim().length() != 0) {
            StringBuilder sb = new StringBuilder(handlersStr.length());
            String[] handlers = Logger.parseClassNames(handlersStr);
            int i = 0;
            while (i < handlers.length) {
                String handler = handlers[i];
                if (handler.startsWith("org.eclipse.vjet.dsf.logger")) {
                    ebayHandlerNames.add(handler);
                } else {
                    if (sb.length() != 0) {
                        sb.append(' ');
                    }
                    sb.append(handler);
                }
                ++i;
            }
            props2.setProperty("handlers", sb.toString());
        } else {
            ebayHandlerNames.add(EbayLogFileHandler.class.getName());
        }
        String levelStr = props2.getProperty(".level");
        if (levelStr == null || levelStr.trim().length() == 0) {
            props2.setProperty(".level", "WARNING");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        props2.store(os, null);
        byte[] data = os.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private static String[] parseClassNames(String hands) {
        if (hands == null) {
            return new String[0];
        }
        hands = hands.trim();
        int ix = 0;
        Vector<String> result = new Vector<String>();
        while (ix < hands.length()) {
            int end = ix;
            while (end < hands.length()) {
                if (Character.isWhitespace(hands.charAt(end)) || hands.charAt(end) == ',') break;
                ++end;
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        this.m_logger.setUseParentHandlers(useParentHandlers);
    }

    public synchronized boolean getUseParentHandlers() {
        return this.m_logger.getUseParentHandlers();
    }

    public boolean isDebugEnabled() {
        return this.m_logger.isLoggable(LogLevel.DEBUG.getLevel());
    }

    public boolean isInfoEnabled() {
        return this.m_logger.isLoggable(LogLevel.INFO.getLevel());
    }

    public boolean isLogEnabled(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        return this.m_logger.isLoggable(logLevel.getLevel());
    }

    public void log(LogLevel logLevel, String message) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        this.m_logger.log(logLevel.getLevel(), message);
    }

    public void log(LogLevel logLevel, String message, String statusString) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        this.m_logger.log(logLevel.getLevel(), message);
    }

    public void log(LogLevel logLevel, String message, Object[] messageArgs) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        this.m_logger.log(logLevel.getLevel(), message, messageArgs);
    }

    public void log(LogLevel logLevel, String message, Object[] messageArgs, boolean includeContextInfo) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        LoggingContext.ContextLoggingOption current = LoggingContext.getContextLoggingOption();
        try {
            LoggingContext.setContextLoggingOption(includeContextInfo ? LoggingContext.ContextLoggingOption.ON : LoggingContext.ContextLoggingOption.OFF);
            this.m_logger.log(logLevel.getLevel(), message, messageArgs);
        }
        finally {
            LoggingContext.setContextLoggingOption(current);
        }
    }

    public void log(LogLevel logLevel, String message, Object[] messageArgs, Throwable t) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        String stringMessage = MessageFormat.format(message, messageArgs);
        this.m_logger.log(logLevel.getLevel(), stringMessage, t);
    }

    public void log(LogLevel logLevel, String stringMessage, Throwable t) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        this.m_logger.log(logLevel.getLevel(), stringMessage, t);
    }

    public void log(LogLevel logLevel, String stringMessage, Throwable t, boolean includeContextInfo) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        LoggingContext.ContextLoggingOption current = LoggingContext.getContextLoggingOption();
        try {
            LoggingContext.setContextLoggingOption(includeContextInfo ? LoggingContext.ContextLoggingOption.ON : LoggingContext.ContextLoggingOption.OFF);
            this.m_logger.log(logLevel.getLevel(), stringMessage, t);
        }
        finally {
            LoggingContext.setContextLoggingOption(current);
        }
    }

    public void log(LogLevel logLevel, String message, boolean includeContextInfo) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        LoggingContext.ContextLoggingOption current = LoggingContext.getContextLoggingOption();
        try {
            LoggingContext.setContextLoggingOption(includeContextInfo ? LoggingContext.ContextLoggingOption.ON : LoggingContext.ContextLoggingOption.OFF);
            this.m_logger.log(logLevel.getLevel(), message);
        }
        finally {
            LoggingContext.setContextLoggingOption(current);
        }
    }

    public void log(LogLevel logLevel, String message, boolean includeContextInfo, String statusString) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        LoggingContext.ContextLoggingOption current = LoggingContext.getContextLoggingOption();
        try {
            LoggingContext.setContextLoggingOption(includeContextInfo ? LoggingContext.ContextLoggingOption.ON : LoggingContext.ContextLoggingOption.OFF);
            LoggingContext.setCalStatus(statusString);
            this.m_logger.log(logLevel.getLevel(), message);
        }
        finally {
            LoggingContext.setContextLoggingOption(current);
            LoggingContext.setCalStatus(null);
        }
    }

    public void log(LogLevel logLevel, String message, Throwable e, String calSourceName) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        try {
            LoggingContext.setSourceName(calSourceName);
            this.m_logger.log(logLevel.getLevel(), message, e);
        }
        finally {
            LoggingContext.setSourceName(null);
        }
    }

    public void log(LogLevel logLevel, Throwable t) {
        if (!this.isLogEnabled(logLevel)) {
            return;
        }
        this.m_logger.log(logLevel.getLevel(), "", t);
    }

    public void log(Throwable t) {
        if (t instanceof BaseException) {
            this.log(LogLevel.ERROR, t);
            return;
        }
        if (t instanceof BaseRuntimeException) {
            this.log(LogLevel.FATAL, t);
            return;
        }
        if (t instanceof RuntimeException) {
            this.log(LogLevel.FATAL, t);
            return;
        }
        if (t instanceof Error) {
            this.log(LogLevel.FATAL, t);
            return;
        }
        this.log(LogLevel.ERROR, t);
    }

    public void debug(String message) {
        this.log(LogLevel.FINE, message);
    }

    public void fine(String message) {
        this.log(LogLevel.FINE, message, true);
    }

    public void finer(String message) {
        this.log(LogLevel.FINER, message, true);
    }

    public void finest(String message) {
        this.log(LogLevel.FINEST, message, true);
    }

    public void setLevel(LogLevel logLevel) throws SecurityException {
        this.m_logger.setLevel(logLevel.getLevel());
    }

    public void addHandler(Handler handler) throws SecurityException {
        this.m_logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.m_logger.removeHandler(handler);
    }
}

