/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import org.eclipse.core.runtime.Assert;
import org.eclipse.vjet.dsf.jst.IJstNode;

public class VjoMatch {
    public static final int UNIT_LINE = 1;
    public static final int UNIT_CHARACTER = 2;
    private static final int IS_FILTERED = 4;
    private Object fElement;
    private int fOffset;
    private int fLength;
    private int fFlags;
    private int fAccuracy;
    private int fMatchRule;
    private boolean fIsWriteAccess;
    private boolean fIsReadAccess;
    private boolean fIsScriptdoc;
    private boolean fIsImport;
    private boolean fIsPublic;
    private boolean fIsStatic;
    private IJstNode jstNode;

    public IJstNode getJstNode() {
        return this.jstNode;
    }

    public void setJstNode(IJstNode jstNode) {
        this.jstNode = jstNode;
    }

    public VjoMatch(Object element, int unit, int offset, int length) {
        Assert.isTrue((unit == 2 || unit == 1 ? 1 : 0) != 0);
        this.fElement = element;
        this.fOffset = offset;
        this.fLength = length;
        this.fFlags = unit;
    }

    public VjoMatch(Object element, int offset, int length) {
        this(element, 2, offset, length);
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getBaseUnit() {
        if ((this.fFlags & 1) != 0) {
            return 1;
        }
        return 2;
    }

    public void setFiltered(boolean value) {
        this.fFlags = value ? (this.fFlags |= 4) : (this.fFlags &= 0xFFFFFFFB);
    }

    public boolean isFiltered() {
        return (this.fFlags & 4) != 0;
    }

    public VjoMatch(Object element, int matchRule, int offset, int length, int accuracy, boolean isReadAccess, boolean isWriteAccess, boolean isJavadoc) {
        this(element, offset, length);
        this.fAccuracy = accuracy;
        this.fMatchRule = matchRule;
        this.fIsWriteAccess = isWriteAccess;
        this.fIsReadAccess = isReadAccess;
        this.fIsScriptdoc = isJavadoc;
    }

    public int getAccuracy() {
        return this.fAccuracy;
    }

    public boolean isWriteAccess() {
        return this.fIsWriteAccess;
    }

    public boolean isReadAccess() {
        return this.fIsReadAccess;
    }

    public boolean isScriptdoc() {
        return this.fIsScriptdoc;
    }

    public int getMatchRule() {
        return this.fMatchRule;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fAccuracy;
        result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
        result = 31 * result + this.fFlags;
        result = 31 * result + (this.fIsReadAccess ? 1231 : 1237);
        result = 31 * result + (this.fIsScriptdoc ? 1231 : 1237);
        result = 31 * result + (this.fIsWriteAccess ? 1231 : 1237);
        result = 31 * result + (this.fIsImport ? 1231 : 1237);
        result = 31 * result + this.fLength;
        result = 31 * result + this.fMatchRule;
        result = 31 * result + this.fOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VjoMatch other = (VjoMatch)obj;
        if (this.fAccuracy != other.fAccuracy) {
            return false;
        }
        if (this.fElement == null ? other.fElement != null : !this.fElement.equals(other.fElement)) {
            return false;
        }
        if (this.fFlags != other.fFlags) {
            return false;
        }
        if (this.fIsReadAccess != other.fIsReadAccess) {
            return false;
        }
        if (this.fIsScriptdoc != other.fIsScriptdoc) {
            return false;
        }
        if (this.fIsWriteAccess != other.fIsWriteAccess) {
            return false;
        }
        if (this.fLength != other.fLength) {
            return false;
        }
        if (this.fMatchRule != other.fMatchRule) {
            return false;
        }
        if (this.fOffset != other.fOffset) {
            return false;
        }
        return this.fIsImport == other.fIsImport;
    }

    public boolean isIsImport() {
        return this.fIsImport;
    }

    public void setIsImport(boolean isImport) {
        this.fIsImport = isImport;
    }

    public void setIsScriptdoc(boolean isScriptdoc) {
        this.fIsScriptdoc = isScriptdoc;
    }

    public boolean isPublic() {
        return this.fIsPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.fIsPublic = isPublic;
    }

    public boolean isStatic() {
        return this.fIsStatic;
    }

    public void setIsStatic(boolean isStatic) {
        this.fIsStatic = isStatic;
    }
}

