/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.views;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.dltk.mod.internal.core.VjoExternalSourceModule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;
import org.eclipse.vjet.eclipse.internal.debug.command.VjetSourceCommands;
import org.eclipse.vjet.eclipse.internal.debug.ui.VjetDebugUIMessages;
import org.eclipse.vjet.eclipse.internal.launching.VjoDBGPSourceModule;
import org.eclipse.vjet.eclipse.launching.VjetLaunchingPlugin;
import org.eclipse.vjet.eclipse.ui.VjetUIImages;

public class RunningScriptView
extends ViewPart
implements ISelectionListener,
IDebugEventSetListener {
    public static final String ID = "org.eclipse.vjet.eclipse.debug.ui.runningScriptView";
    private Map<URI, Object> m_contentsCache;
    private IScriptThread m_lastSelectedThread;
    private Action m_openFileAction;
    private TableViewer m_viewer;
    private Image m_defaultScriptImg;

    public void createPartControl(Composite parent) {
        this.m_viewer = new TableViewer(parent, 66306);
        this.m_viewer.setContentProvider((IContentProvider)new RunningScriptViewContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new RunningScriptViewLabelProvider());
        this.m_viewer.setSorter((ViewerSorter)new NameSorter(true));
        Table table = this.m_viewer.getTable();
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setWidth(20);
        column = new TableColumn(table, 16384, 1);
        column.setText(VjetDebugUIMessages.RunningScriptView_column_name);
        column.setWidth(600);
        column.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NameSorter sorter = (NameSorter)RunningScriptView.this.m_viewer.getSorter();
                sorter.m_order = !sorter.m_order;
                RunningScriptView.this.m_viewer.setSorter((ViewerSorter)sorter);
                RunningScriptView.this.m_viewer.refresh();
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.m_defaultScriptImg != null) {
            this.m_defaultScriptImg.dispose();
        }
        if (this.m_viewer != null) {
            this.m_viewer.getTable().dispose();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            int kind = event.getKind();
            int detail = event.getDetail();
            block0 : switch (kind) {
                case 2: {
                    switch (detail) {
                        case 8: 
                        case 16: {
                            if (!(source instanceof IScriptThread)) break block0;
                            this.fetchScriptList((IScriptThread)source);
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    if (!(source instanceof IScriptThread) || !source.equals(this.m_lastSelectedThread)) break;
                    this.clear();
                    this.m_lastSelectedThread = null;
                    break;
                }
            }
            ++n2;
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor("org.eclipse.vjet.ui.VjetJsEditor");
        ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
        this.m_defaultScriptImg = imageDesc != null ? imageDesc.createImage() : null;
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addPostSelectionListener((ISelectionListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        ISelection selection = selectionService.getSelection("org.eclipse.debug.ui.DebugView");
        if (selection != null) {
            this.selectionChanged(null, selection);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object sel = ((IStructuredSelection)selection).getFirstElement();
        if (!(sel instanceof IScriptThread) && !(sel instanceof IScriptStackFrame)) {
            return;
        }
        IScriptThread currentSelectedThread = (IScriptThread)(sel instanceof IScriptThread ? sel : ((IScriptStackFrame)sel).getThread());
        if (this.m_lastSelectedThread != null && this.m_lastSelectedThread.equals(currentSelectedThread)) {
            return;
        }
        this.handleSelectionChangedEvent(currentSelectedThread);
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    protected void openEditor(Object input) {
        if (!(input instanceof URI)) {
            return;
        }
        URI uri = (URI)input;
        try {
            Object sourceElement = this.getSourceElement(uri);
            if (sourceElement == null) {
                return;
            }
            IDebugModelPresentation presentation = ((DelegatingModelPresentation)DebugUIPlugin.getModelPresentation()).getPresentation(this.m_lastSelectedThread.getModelIdentifier());
            IEditorInput editorInput = null;
            String editorId = null;
            if (presentation == null) {
                return;
            }
            editorInput = presentation.getEditorInput(sourceElement);
            editorId = presentation.getEditorId(editorInput, sourceElement);
            SourceLookupResult result = new SourceLookupResult((Object)uri, sourceElement, editorId, editorInput);
            DebugUITools.displaySource((ISourceLookupResult)result, (IWorkbenchPage)this.getViewSite().getPage());
        }
        catch (Exception e) {
            VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
        }
    }

    private void clear() {
        new UIJob(this.getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RunningScriptView.this.m_viewer.setInput((Object)new URI[0]);
                RunningScriptView.this.m_viewer.refresh();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void fetchScriptList(final IScriptThread thread) {
        if (thread.isTerminated()) {
            return;
        }
        this.m_lastSelectedThread = thread;
        if (this.m_contentsCache != null) {
            this.m_contentsCache.clear();
        }
        new UIJob(this.getDisplay(), VjetDebugUIMessages.RunningScriptView_refresh_job_name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    VjetSourceCommands vjetSourceCommands = new VjetSourceCommands(thread.getDbgpSession().getCommunicator());
                    URI[] fileURIs = vjetSourceCommands.list();
                    RunningScriptView.this.m_viewer.setInput((Object)fileURIs);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.vjet.eclipse.debug.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.m_openFileAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.m_openFileAction);
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    private Image getElementImage(Object object) {
        Image img = null;
        img = object instanceof VjoExternalSourceModule ? VjetUIImages.getImage((String)"IMAGE_BINARY_EDITOR_TITLE") : this.m_defaultScriptImg;
        return img;
    }

    private Object getSourceElement(URI uri) throws MalformedURLException, ModelException {
        Object sourceElement;
        if (this.m_contentsCache == null) {
            this.m_contentsCache = new HashMap<URI, Object>();
        }
        if ((sourceElement = this.m_contentsCache.get(uri)) != null) {
            return sourceElement;
        }
        if (this.m_lastSelectedThread == null) {
            return null;
        }
        ISourceLocator sourceLocator = this.m_lastSelectedThread.getLaunch().getSourceLocator();
        if (sourceLocator != null && sourceLocator instanceof ISourceLookupDirector) {
            sourceElement = ((ISourceLookupDirector)sourceLocator).getSourceElement((Object)uri);
            if (sourceElement instanceof VjoDBGPSourceModule) {
                VjoDBGPSourceModule sm = (VjoDBGPSourceModule)sourceElement;
                sm.setDBGPSession(this.m_lastSelectedThread.getDbgpSession());
            }
            return sourceElement;
        }
        this.m_contentsCache.put(uri, sourceElement);
        return sourceElement;
    }

    private void handleSelectionChangedEvent(IScriptThread selectedThread) {
        this.fetchScriptList(selectedThread);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RunningScriptView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_viewer);
    }

    private void hookDoubleClickAction() {
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RunningScriptView.this.m_openFileAction.run();
            }
        });
    }

    private void makeActions() {
        this.m_openFileAction = new Action(VjetDebugUIMessages.RunningScriptView_open_file_action_name){

            public void run() {
                ISelection selection = RunningScriptView.this.m_viewer.getSelection();
                Object element = ((IStructuredSelection)selection).getFirstElement();
                RunningScriptView.this.openEditor(element);
            }
        };
        this.m_openFileAction.setToolTipText(VjetDebugUIMessages.RunningScriptView_open_file_action_tooltip);
    }

    private class NameSorter
    extends ViewerSorter {
        boolean m_order;

        NameSorter(boolean asc) {
            this.m_order = asc;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.m_order ? super.compare(viewer, e1, e2) : super.compare(viewer, e2, e1);
        }
    }

    private class RunningScriptViewContentProvider
    implements IStructuredContentProvider {
        private RunningScriptViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof URI[])) {
                return new URI[0];
            }
            return (URI[])inputElement;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RunningScriptViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RunningScriptViewLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            switch (columnIndex) {
                case 0: {
                    try {
                        Object sourceElement = RunningScriptView.this.getSourceElement((URI)element);
                        img = RunningScriptView.this.getElementImage(sourceElement);
                    }
                    catch (Exception e) {
                        VjetLaunchingPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
                    }
                    break;
                }
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return this.format(element);
                }
            }
            return null;
        }

        private String format(Object element) {
            URI uri = (URI)element;
            String text = "";
            if ("dbgp".equals(uri.getScheme())) {
                try {
                    Object sourceElement = RunningScriptView.this.getSourceElement(uri);
                    if (sourceElement instanceof VjoExternalSourceModule) {
                        text = ((VjoExternalSourceModule)sourceElement).getName();
                    }
                }
                catch (Exception e) {
                    VjetLaunchingPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (text.isEmpty()) {
                text = uri.toString();
            }
            return text;
        }
    }
}

