/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.io.InputStream;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.mod.ui.preferences.AbstractScriptEditorColoringConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.mod.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.mod.ui.text.IColorManager;
import org.eclipse.dltk.mod.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.mod.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vjet.eclipse.internal.ui.editor.JavaScriptDocumentSetupParticipant;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlighting;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlightingManager;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlightings;
import org.eclipse.vjet.eclipse.internal.ui.text.SimpleVjoSourceViewerConfiguration;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjetEditorColoringConfigurationBlock
extends AbstractScriptEditorColoringConfigurationBlock
implements IPreferenceConfigurationBlock {
    public static final String JS_DOC = "Jsdoc";
    private static final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.DLTKEditorPreferencePage_singleLineComment, "VJET_single_line_comment", sCommentsCategory}, {"Multi-line comment", "VJET_multi_line_comment", sCommentsCategory}, {"Task Tags", "VJET_task_tags_comment", sCommentsCategory}, {PreferencesMessages.DLTKEditorPreferencePage_keywords, "DLTK_keyword", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_returnKeyword, "DLTK_keyword_return", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_strings, "DLTK_string", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_regexps, "VJET_regexp_core", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_default, "DLTK_default", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_numbers, "DLTK_number", sCoreCategory}, {"HTML Markup", "VJET_javadoc_html_markup", "Jsdoc"}, {"Links", "VJET_javadoc_links", "Jsdoc"}, {"Others", "VJET_javadoc_others", "Jsdoc"}, {"Tags", "VJET_javadoc_tags", "Jsdoc"}};
    private static final String PREVIEW_FILE_NAME = "PreviewFile.txt";
    protected VjoSemanticHighlightingManager fSemanticHighlightingManager;

    public VjetEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
    }

    protected AbstractScriptEditorColoringConfigurationBlock.SemanticHighlightingColorListItem createSemanticHighlightingItem(SemanticHighlighting highLighting) {
        if (highLighting instanceof VjoSemanticHighlighting) {
            VjoSemanticHighlighting vjoSemanticHighlighting = (VjoSemanticHighlighting)highLighting;
            return new AbstractScriptEditorColoringConfigurationBlock.SemanticHighlightingColorListItem(vjoSemanticHighlighting.getDisplayName(), VjoSemanticHighlightings.getColorPreferenceKey(vjoSemanticHighlighting), VjoSemanticHighlightings.getBoldPreferenceKey(vjoSemanticHighlighting), VjoSemanticHighlightings.getItalicPreferenceKey(vjoSemanticHighlighting), VjoSemanticHighlightings.getStrikethroughPreferenceKey(vjoSemanticHighlighting), VjoSemanticHighlightings.getUnderlinePreferenceKey(vjoSemanticHighlighting), sCoreCategory, VjoSemanticHighlightings.getEnabledPreferenceKey(vjoSemanticHighlighting));
        }
        return super.createSemanticHighlightingItem(highLighting);
    }

    protected ProjectionViewer createPreviewViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        return new ScriptSourceViewer(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
    }

    protected ScriptSourceViewerConfiguration createSimpleSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new SimpleVjoSourceViewerConfiguration(colorManager, preferenceStore, editor, "__javascript_partitioning", configureFormatter);
    }

    protected String[] getCategories() {
        return new String[]{sCoreCategory, sDocumentationCategory, sCommentsCategory, JS_DOC};
    }

    protected InputStream getPreviewContentReader() {
        return ((Object)((Object)this)).getClass().getResourceAsStream(PREVIEW_FILE_NAME);
    }

    protected String[][] getSyntaxColorListModel() {
        return fSyntaxColorListModel;
    }

    protected void setDocumentPartitioning(IDocument document) {
        JavaScriptDocumentSetupParticipant participant = new JavaScriptDocumentSetupParticipant();
        participant.setup(document);
    }

    protected Preferences createTemporaryCorePreferenceStore() {
        return VjetUIPlugin.getDefault().getPluginPreferences();
    }

    protected ScriptTextTools getTextTools() {
        return VjetUIPlugin.getDefault().getTextTools();
    }

    protected void installSemanticHighlighting() {
        final ScriptTextTools textTools = this.getTextTools();
        if (this.fSemanticHighlightingManager == null && textTools != null) {
            this.fSemanticHighlightingManager = new VjoSemanticHighlightingManager(){

                @Override
                protected ScriptTextTools getTextTools() {
                    return textTools;
                }
            };
            this.fSemanticHighlightingManager.install((ScriptSourceViewer)this.fPreviewViewer, this.fColorManager, (IPreferenceStore)this.getPreferenceStore(), this.createPreviewerRanges());
        }
    }

    private VjoSemanticHighlightingManager.HighlightedRange createHighlightedRange(int line, int column, int length, String key) {
        try {
            IDocument document = this.fPreviewViewer.getDocument();
            int offset = document.getLineOffset(line) + column;
            return new VjoSemanticHighlightingManager.HighlightedRange(offset, length, key);
        }
        catch (BadLocationException x) {
            DLTKUIPlugin.log((Throwable)x);
            return null;
        }
    }

    protected int getLine(String text) throws BadLocationException {
        IDocument document = this.fPreviewViewer.getDocument();
        int index = document.get().indexOf(text);
        return document.getLineOfOffset(index);
    }

    protected int getColumn(int line, String text) throws BadLocationException {
        IDocument document = this.fPreviewViewer.getDocument();
        int index = document.get().indexOf(text);
        int column = index - document.getLineOffset(line);
        return column;
    }

    private VjoSemanticHighlightingManager.HighlightedRange[][] createPreviewerRanges() {
        return new VjoSemanticHighlightingManager.HighlightedRange[][]{{this.createHighlightedRange(18, 2, 6, "methodDeclarationName")}, {this.createHighlightedRange(25, 5, 3, "methodDeclarationName")}, {this.createHighlightedRange(35, 5, 3, "methodDeclarationName")}};
    }
}

