/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.internal.core.util.VjoFlags;

public class RefactoringScopeFactory {
    private static void addReferencingProjects(IScriptProject focus, Set projects) throws ModelException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IBuildpathEntry entry;
            IScriptProject candidate = DLTKCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++i;
        }
    }

    public static IDLTKSearchScope create(IModelElement javaElement) throws ModelException {
        return RefactoringScopeFactory.create(javaElement, true);
    }

    public static IDLTKSearchScope create(IModelElement javaElement, boolean considerVisibility) throws ModelException {
        IMember member;
        if (considerVisibility & javaElement instanceof IMember && VjoFlags.isPrivate((IMember)(member = (IMember)javaElement))) {
            if (member.getSourceModule() != null) {
                return SearchEngine.createSearchScope((IModelElement)member.getSourceModule());
            }
            return SearchEngine.createSearchScope((IModelElement)member);
        }
        return RefactoringScopeFactory.create(javaElement.getScriptProject());
    }

    private static IDLTKSearchScope create(IScriptProject javaProject) throws ModelException {
        return SearchEngine.createSearchScope((IModelElement[])RefactoringScopeFactory.getAllScopeElements(javaProject), (boolean)false, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)javaProject));
    }

    private static IModelElement[] getAllScopeElements(IScriptProject project) throws ModelException {
        Collection sourceRoots = RefactoringScopeFactory.getAllSourceRootsInProjects(RefactoringScopeFactory.getReferencingProjects(project));
        return sourceRoots.toArray(new IProjectFragment[sourceRoots.size()]);
    }

    private static Collection getAllSourceRootsInProjects(Collection projects) throws ModelException {
        ArrayList result = new ArrayList();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            result.addAll(RefactoringScopeFactory.getSourceRoots((IScriptProject)it.next()));
        }
        return result;
    }

    private static IBuildpathEntry getReferencingClassPathEntry(IScriptProject referencingProject, IScriptProject referencedProject) throws ModelException {
        IBuildpathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IBuildpathEntry[] classpath = referencingProject.getResolvedBuildpath(true);
        int i = 0;
        while (i < classpath.length) {
            IBuildpathEntry entry = classpath[i];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++i;
        }
        return result;
    }

    private static Collection getReferencingProjects(IScriptProject focus) throws ModelException {
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private static List getSourceRoots(IScriptProject javaProject) throws ModelException {
        ArrayList<IProjectFragment> elements = new ArrayList<IProjectFragment>();
        IProjectFragment[] roots = javaProject.getProjectFragments();
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (!root.isArchive()) {
                elements.add(root);
            }
            ++i;
        }
        return elements;
    }

    private RefactoringScopeFactory() {
    }
}

