/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.IJSInitializer;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.mod.ui.templates.ScriptTemplateCompletionProcessor;
import org.eclipse.dltk.mod.ui.templates.TemplateInformationControlCreator;
import org.eclipse.dltk.mod.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.keywords.IVjoCompletionData;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;
import org.eclipse.vjet.eclipse.internal.ui.templates.VjoTemplateAccess;
import org.eclipse.vjet.eclipse.ui.text.completion.VjoTemplateProposal;

public class VjoTemplateCompletionProcessor
extends ScriptTemplateCompletionProcessor {
    public VjoTemplateCompletionProcessor(ScriptContentAssistInvocationContext cntx) {
        super(cntx);
    }

    protected String getContextTypeId() {
        return "vjoTemplateContextType";
    }

    protected char[] getIgnore() {
        return new char[0];
    }

    protected ScriptTemplateAccess getTemplateAccess() {
        return VjoTemplateAccess.getInstance();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = super.computeCompletionProposals(viewer, offset);
        try {
            boolean isMethodScope;
            ISourceModule module = this.getContext().getSourceModule();
            if (!CodeassistUtils.isVjoSourceModule((IModelElement)module)) {
                return new ICompletionProposal[0];
            }
            IScriptProject project = module.getScriptProject();
            if (project == null || !project.exists()) {
                return proposals;
            }
            boolean bl = isMethodScope = module != null;
            if (isMethodScope) {
                boolean bl2 = isMethodScope = !project.isOnBuildpath((IModelElement)module);
                if (!isMethodScope) {
                    IModelElement e = module.getElementAt(offset);
                    boolean bl3 = isMethodScope = e instanceof IMethod || e instanceof VjoSourceType || e instanceof IJSInitializer;
                }
            }
            if (isMethodScope) {
                return proposals;
            }
            ArrayList<ICompletionProposal> scopeFiltered = new ArrayList<ICompletionProposal>();
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal completionProposal = iCompletionProposalArray[n2];
                String displayName = completionProposal.getDisplayString();
                if (!(displayName.startsWith(VjoKeywordFactory.KWD_DO.getName()) || displayName.startsWith(VjoKeywordFactory.KWD_FOR.getName()) || displayName.startsWith(VjoKeywordFactory.KWD_IF.getName()) || displayName.startsWith(VjoKeywordFactory.KWD_SWITCH.getName()) || displayName.startsWith(VjoKeywordFactory.KWD_TRY.getName()) || displayName.startsWith(VjoKeywordFactory.KWD_WHILE.getName()))) {
                    scopeFiltered.add(completionProposal);
                }
                ++n2;
            }
            return scopeFiltered.toArray(new ICompletionProposal[0]);
        }
        catch (ModelException me) {
            me.printStackTrace();
            return proposals;
        }
    }

    private ICompletionProposal[] filter(ICompletionProposal[] allTemplates, List<IVjoCompletionData> allowedKeywords) {
        ArrayList<ICompletionProposal> filteredTemplates = new ArrayList<ICompletionProposal>();
        int iter = 0;
        while (iter < allTemplates.length) {
            for (IVjoCompletionData keyword : allowedKeywords) {
                if (!allTemplates[iter].getDisplayString().toLowerCase().startsWith(keyword.toString()) || keyword.isComplementedPart()) continue;
                filteredTemplates.add(allTemplates[iter]);
                break;
            }
            ++iter;
        }
        return filteredTemplates.toArray(new ICompletionProposal[0]);
    }

    protected IInformationControlCreator getInformationControlCreator() {
        int orientation = Window.getDefaultOrientation();
        IEditorPart editor = this.getContext().getEditor();
        if (editor == null) {
            editor = DLTKUIPlugin.getActivePage().getActiveEditor();
        }
        if (editor instanceof IWorkbenchPartOrientation) {
            orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getContext().getLanguageNatureID());
        if (toolkit == null && editor instanceof ScriptEditor) {
            toolkit = ((ScriptEditor)editor).getLanguageToolkit();
        }
        return new TemplateInformationControlCreator(orientation, toolkit);
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        VjoTemplateProposal proposal = new VjoTemplateProposal(template, context, region, this.getImage(template), relevance);
        proposal.setInformationControlCreator(this.getInformationControlCreator());
        return proposal;
    }
}

